/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.factions.zcore.util;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.P;
import com.massivecraft.factions.shade.mkremins.fanciful.FancyMessage;
import com.massivecraft.factions.util.MiscUtil;
import com.massivecraft.factions.zcore.util.TagReplacer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;

public class TagUtil {
    private static final int ARBITRARY_LIMIT = 25000;

    public static String parsePlain(Faction faction, String line) {
        for (TagReplacer tagReplacer : TagReplacer.getByType(TagReplacer.TagType.FACTION)) {
            if (!tagReplacer.contains(line)) continue;
            line = tagReplacer.replace(line, tagReplacer.getValue(faction, null));
        }
        return line;
    }

    public static String parsePlain(FPlayer fplayer, String line) {
        for (TagReplacer tagReplacer : TagReplacer.getByType(TagReplacer.TagType.PLAYER)) {
            if (!tagReplacer.contains(line)) continue;
            String rep = tagReplacer.getValue(fplayer.getFaction(), fplayer);
            if (rep == null) {
                rep = "";
            }
            line = tagReplacer.replace(line, rep);
        }
        return line;
    }

    public static String parsePlain(Faction faction, FPlayer fplayer, String line) {
        for (TagReplacer tagReplacer : TagReplacer.getByType(TagReplacer.TagType.PLAYER)) {
            if (!tagReplacer.contains(line)) continue;
            line = tagReplacer.replace(line, tagReplacer.getValue(faction, fplayer));
        }
        return line;
    }

    public static List<FancyMessage> parseFancy(Faction faction, FPlayer fme, String line) {
        for (TagReplacer tagReplacer : TagReplacer.getByType(TagReplacer.TagType.FANCY)) {
            if (!tagReplacer.contains(line)) continue;
            String clean = line.replace(tagReplacer.getTag(), "");
            return TagUtil.getFancy(faction, fme, tagReplacer, clean);
        }
        return null;
    }

    public static boolean hasFancy(String line) {
        for (TagReplacer tagReplacer : TagReplacer.getByType(TagReplacer.TagType.FANCY)) {
            if (!tagReplacer.contains(line)) continue;
            return true;
        }
        return false;
    }

    protected static List<FancyMessage> getFancy(Faction target, FPlayer fme, TagReplacer type, String prefix) {
        ArrayList<FancyMessage> fancyMessages = new ArrayList<FancyMessage>();
        switch (type) {
            case ALLIES_LIST: {
                FancyMessage currentAllies = P.p.txt.parseFancy(prefix);
                boolean firstAlly = true;
                for (Faction otherFaction : Factions.getInstance().getAllFactions()) {
                    if (otherFaction == target) continue;
                    String s = otherFaction.getTag(fme);
                    if (!otherFaction.getRelationTo(target).isAlly()) continue;
                    currentAllies.then(firstAlly ? s : ", " + s);
                    currentAllies.tooltip(TagUtil.tipFaction(otherFaction)).color(fme.getColorTo(otherFaction));
                    firstAlly = false;
                    if (currentAllies.toJSONString().length() <= 25000) continue;
                    fancyMessages.add(currentAllies);
                    currentAllies = new FancyMessage("");
                }
                fancyMessages.add(currentAllies);
                return fancyMessages;
            }
            case ENEMIES_LIST: {
                FancyMessage currentEnemies = P.p.txt.parseFancy(prefix);
                boolean firstEnemy = true;
                for (Faction otherFaction : Factions.getInstance().getAllFactions()) {
                    if (otherFaction == target) continue;
                    String s = otherFaction.getTag(fme);
                    if (!otherFaction.getRelationTo(target).isEnemy()) continue;
                    currentEnemies.then(firstEnemy ? s : ", " + s);
                    currentEnemies.tooltip(TagUtil.tipFaction(otherFaction)).color(fme.getColorTo(otherFaction));
                    firstEnemy = false;
                    if (currentEnemies.toJSONString().length() <= 25000) continue;
                    fancyMessages.add(currentEnemies);
                    currentEnemies = new FancyMessage("");
                }
                fancyMessages.add(currentEnemies);
                return fancyMessages;
            }
            case ONLINE_LIST: {
                FancyMessage currentOnline = P.p.txt.parseFancy(prefix);
                boolean firstOnline = true;
                for (FPlayer p : MiscUtil.rankOrder(target.getFPlayersWhereOnline(true))) {
                    String name = p.getNameAndTitle();
                    currentOnline.then(firstOnline ? name : ", " + name);
                    currentOnline.tooltip(TagUtil.tipPlayer(p)).color(fme.getColorTo(p));
                    firstOnline = false;
                    if (currentOnline.toJSONString().length() <= 25000) continue;
                    fancyMessages.add(currentOnline);
                    currentOnline = new FancyMessage("");
                }
                fancyMessages.add(currentOnline);
                return fancyMessages;
            }
            case OFFLINE_LIST: {
                FancyMessage currentOffline = P.p.txt.parseFancy(prefix);
                boolean firstOffline = true;
                for (FPlayer p : MiscUtil.rankOrder(target.getFPlayers())) {
                    String name = p.getNameAndTitle();
                    if (p.isOnline()) continue;
                    currentOffline.then(firstOffline ? name : ", " + name);
                    currentOffline.tooltip(TagUtil.tipPlayer(p)).color(fme.getColorTo(p));
                    firstOffline = false;
                    if (currentOffline.toJSONString().length() <= 25000) continue;
                    fancyMessages.add(currentOffline);
                    currentOffline = new FancyMessage("");
                }
                fancyMessages.add(currentOffline);
                return fancyMessages;
            }
        }
        return null;
    }

    private static List<String> tipFaction(Faction faction) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : P.p.getConfig().getStringList("tooltips.list")) {
            lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)TagUtil.parsePlain(faction, line)));
        }
        return lines;
    }

    private static List<String> tipPlayer(FPlayer fplayer) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : P.p.getConfig().getStringList("tooltips.show")) {
            lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)TagUtil.parsePlain(fplayer, line)));
        }
        return lines;
    }
}

