/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore;

public final class HeatData {
    public static final transient double HEAT_MIN = 0.0;
    public static final transient double HEAT_HIGH = 1.0;
    public static final transient long MILLIS_CALC_EPSILON = 50L;
    private final double heat;
    private final long lastCalcMillis;

    public double getHeat() {
        return this.heat;
    }

    public long getLastCalcMillis() {
        return this.lastCalcMillis;
    }

    public double getOverheat() {
        return this.getHeat() - 1.0;
    }

    public boolean isOverheated() {
        return this.getOverheat() > 0.0;
    }

    public HeatData withHeat(double heat) {
        return new HeatData(heat, this.lastCalcMillis);
    }

    public HeatData withLastCalcMillis(long lastCalcMillis) {
        return new HeatData(this.heat, lastCalcMillis);
    }

    private HeatData(double heat, long lastCalcMillis) {
        this.heat = Math.max(0.0, heat);
        this.lastCalcMillis = lastCalcMillis;
    }

    private HeatData() {
        this.heat = 0.0;
        this.lastCalcMillis = 0L;
    }

    public static HeatData valueOf(double heat, long lastCalcMillis) {
        return new HeatData(heat, lastCalcMillis);
    }

    public HeatData recalculated(long now, double heatPerMilli) {
        if (this.lastCalcMillis + 50L >= now) {
            return this;
        }
        long deltaMillis = now - this.lastCalcMillis;
        double heatDelta = heatPerMilli * (double)deltaMillis;
        double heatTarget = this.heat + heatDelta;
        heatTarget = Math.max(0.0, heatTarget);
        return HeatData.valueOf(heatTarget, now);
    }
}

