/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore;

import com.massivecraft.massivecore.EngineAbstract;
import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.cmd.MassiveCommand;
import com.massivecraft.massivecore.cmd.MassiveCoreBukkitCommand;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;

public class MassiveCoreEngineCommandRegistration
extends EngineAbstract {
    private static MassiveCoreEngineCommandRegistration i = new MassiveCoreEngineCommandRegistration();

    public static MassiveCoreEngineCommandRegistration get() {
        return i;
    }

    @Override
    public Plugin getPlugin() {
        return MassiveCore.get();
    }

    @Override
    public Long getPeriod() {
        return 20L;
    }

    @Override
    public void run() {
        MassiveCoreEngineCommandRegistration.updateRegistrations();
    }

    public static void updateRegistrations() {
        String name;
        SimpleCommandMap simpleCommandMap = MassiveCoreEngineCommandRegistration.getSimpleCommandMap();
        Map<String, Command> knownCommands = MassiveCoreEngineCommandRegistration.getSimpleCommandMapDotKnownCommands(simpleCommandMap);
        HashMap<String, MassiveCommand> nameTargets = new HashMap<String, MassiveCommand>();
        for (MassiveCommand massiveCommand : MassiveCommand.getRegisteredCommands()) {
            for (String alias : massiveCommand.getAliases()) {
                if (alias == null) continue;
                alias = alias.trim().toLowerCase();
                nameTargets.put(alias, massiveCommand);
            }
        }
        for (Map.Entry entry : nameTargets.entrySet()) {
            Command current;
            MassiveCommand massiveCurrent;
            name = (String)entry.getKey();
            MassiveCommand target = (MassiveCommand)entry.getValue();
            if (target == (massiveCurrent = MassiveCoreEngineCommandRegistration.getMassiveCommand(current = knownCommands.get(name)))) continue;
            if (current != null) {
                knownCommands.remove(name);
                current.unregister((CommandMap)simpleCommandMap);
            }
            MassiveCoreBukkitCommand command = new MassiveCoreBukkitCommand(name, target);
            simpleCommandMap.register("MassiveCore", (Command)command);
        }
        Iterator<Map.Entry<String, Command>> iter = knownCommands.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Command> entry = iter.next();
            name = entry.getKey();
            Command command = entry.getValue();
            MassiveCommand massiveCommand = MassiveCoreEngineCommandRegistration.getMassiveCommand(command);
            if (massiveCommand == null || nameTargets.containsKey(name)) continue;
            command.unregister((CommandMap)simpleCommandMap);
            iter.remove();
        }
    }

    public static SimpleCommandMap getSimpleCommandMap() {
        Server server = Bukkit.getServer();
        return (SimpleCommandMap)MassiveCoreEngineCommandRegistration.get(server.getClass(), "commandMap", server);
    }

    public static Map<String, Command> getSimpleCommandMapDotKnownCommands(SimpleCommandMap simpleCommandMap) {
        return (Map)MassiveCoreEngineCommandRegistration.get(SimpleCommandMap.class, "knownCommands", simpleCommandMap);
    }

    public static MassiveCommand getMassiveCommand(Command command) {
        if (command == null) {
            return null;
        }
        if (!(command instanceof MassiveCoreBukkitCommand)) {
            return null;
        }
        MassiveCoreBukkitCommand mcbc = (MassiveCoreBukkitCommand)command;
        return mcbc.getMassiveCommand();
    }

    public static Object get(Class<?> clazz, String fieldName, Object object) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void set(Class<?> clazz, String fieldName, Object object, Object value) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            return;
        }
    }
}

