/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore;

import com.massivecraft.massivecore.EngineAbstract;
import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.MassiveCoreMConf;
import com.massivecraft.massivecore.event.EventMassiveCoreAfterPlayerRespawn;
import com.massivecraft.massivecore.event.EventMassiveCoreAfterPlayerTeleport;
import com.massivecraft.massivecore.event.EventMassiveCorePermissionDeniedFormat;
import com.massivecraft.massivecore.event.EventMassiveCorePlayerLeave;
import com.massivecraft.massivecore.event.EventMassiveCorePlayerToRecipientChat;
import com.massivecraft.massivecore.event.EventMassiveCoreSenderRegister;
import com.massivecraft.massivecore.event.EventMassiveCoreSenderUnregister;
import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.store.SenderColl;
import com.massivecraft.massivecore.util.IdUtil;
import com.massivecraft.massivecore.util.SmokeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class MassiveCoreEngineMain
extends EngineAbstract {
    private static MassiveCoreEngineMain i = new MassiveCoreEngineMain();
    public static Map<String, String> kickedPlayerReasons = new HashMap<String, String>();

    public static MassiveCoreEngineMain get() {
        return i;
    }

    @Override
    public Plugin getPlugin() {
        return MassiveCore.get();
    }

    @Override
    public void activate() {
        super.activate();
        EventMassiveCorePlayerLeave.player2event.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void recipientChat(AsyncPlayerChatEvent event) {
        EventMassiveCorePlayerToRecipientChat recipientEvent;
        if (!MassiveCoreMConf.get().usingRecipientChatEvent) {
            return;
        }
        Player sender = event.getPlayer();
        String message = event.getMessage();
        String format = event.getFormat();
        HashSet players = new HashSet(event.getRecipients());
        event.getRecipients().clear();
        for (Player recipient : players) {
            recipientEvent = new EventMassiveCorePlayerToRecipientChat(event.isAsynchronous(), sender, (CommandSender)recipient, message, format);
            recipientEvent.run();
            String recipientMessage = String.format(recipientEvent.getFormat(), sender.getDisplayName(), recipientEvent.getMessage());
            recipient.sendMessage(recipientMessage);
        }
        recipientEvent = new EventMassiveCorePlayerToRecipientChat(event.isAsynchronous(), sender, (CommandSender)Bukkit.getConsoleSender(), message, format);
        recipientEvent.run();
        event.setMessage(recipientEvent.getMessage());
        event.setFormat(recipientEvent.getFormat());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void permissionDeniedFormat(EventMassiveCorePermissionDeniedFormat event) {
        if (event.hasFormat()) {
            return;
        }
        String customFormat = MassiveCoreMConf.get().getPermissionDeniedFormat(event.getPermissionName());
        if (customFormat == null) {
            return;
        }
        event.setFormat(customFormat);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void chatTabComplete(PlayerChatTabCompleteEvent event) {
        Player watcher = event.getPlayer();
        String tokenlc = event.getLastToken().toLowerCase();
        TreeSet current = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        current.addAll(event.getTabCompletions());
        for (String senderName : IdUtil.getOnlineNames()) {
            if (!senderName.toLowerCase().startsWith(tokenlc) || current.contains(senderName) || !Mixin.canSee(watcher, senderName)) continue;
            event.getTabCompletions().add(senderName);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void explosionFx(EntityDamageByBlockEvent event) {
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            return;
        }
        if (!SmokeUtil.fakeExplosion.booleanValue()) {
            return;
        }
        event.setCancelled(true);
    }

    public static void setSenderReferences(CommandSender sender, CommandSender reference) {
        String name;
        String id = IdUtil.getId(sender);
        if (id != null) {
            SenderColl.setSenderReferences(id, reference);
        }
        if ((name = IdUtil.getName(sender)) != null) {
            SenderColl.setSenderReferences(name, reference);
        }
    }

    public static void setSenderReferences(Player player) {
        Player reference = player;
        if (!player.isOnline()) {
            reference = null;
        }
        MassiveCoreEngineMain.setSenderReferences((CommandSender)player, (CommandSender)reference);
    }

    public static void setSenderReferencesSoon(final Player player) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MassiveCore.get(), new Runnable(){

            @Override
            public void run() {
                MassiveCoreEngineMain.setSenderReferences(player);
            }
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void setSenderReferencesLoginLowest(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        MassiveCoreEngineMain.setSenderReferences((CommandSender)player, (CommandSender)player);
        MassiveCoreEngineMain.setSenderReferencesSoon(player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void setSenderReferencesQuitMonitor(PlayerQuitEvent event) {
        MassiveCoreEngineMain.setSenderReferencesSoon(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void setSenderReferencesRegisterMonitor(EventMassiveCoreSenderRegister event) {
        MassiveCoreEngineMain.setSenderReferences(event.getSender(), event.getSender());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void setSenderReferencesUnregisterMonitor(EventMassiveCoreSenderUnregister event) {
        MassiveCoreEngineMain.setSenderReferences(event.getSender(), null);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void after(PlayerTeleportEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MassiveCore.get(), (Runnable)new EventMassiveCoreAfterPlayerTeleport(event), 0L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void after(PlayerRespawnEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MassiveCore.get(), (Runnable)new EventMassiveCoreAfterPlayerRespawn(event, event.getPlayer().getLocation()), 0L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void causedByKick(PlayerKickEvent event) {
        String name = event.getPlayer().getName();
        kickedPlayerReasons.put(name, event.getReason());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void causedByKick(PlayerQuitEvent event) {
        final String name = event.getPlayer().getName();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MassiveCore.get(), new Runnable(){

            @Override
            public void run() {
                kickedPlayerReasons.remove(name);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void leaveEventKickCall(PlayerKickEvent event) {
        new EventMassiveCorePlayerLeave(event.getPlayer(), true, "kick", event.getReason()).run();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void leaveEventQuitCall(PlayerQuitEvent event) {
        new EventMassiveCorePlayerLeave(event.getPlayer(), false, "quit", null).run();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void leaveEventQuitClear(PlayerQuitEvent event) {
        final String name = event.getPlayer().getName();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MassiveCore.get(), new Runnable(){

            @Override
            public void run() {
                EventMassiveCorePlayerLeave.player2event.remove(name);
            }
        });
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void syncOnPlayerLogin(PlayerLoginEvent event) {
        this.syncAllForPlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void syncOnPlayerLeave(EventMassiveCorePlayerLeave event) {
        this.syncAllForPlayer(event.getPlayer());
    }

    public void syncAllForPlayer(Player player) {
        String playerName = player.getName();
        String playerId = player.getUniqueId().toString();
        for (Coll<?> coll : Coll.getInstances()) {
            if (!(coll instanceof SenderColl)) continue;
            SenderColl pcoll = (SenderColl)coll;
            pcoll.syncId(playerName);
            pcoll.syncId(playerId);
        }
    }
}

