/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore;

import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.MetricsLite;
import com.massivecraft.massivecore.cmd.MassiveCommand;
import com.massivecraft.massivecore.integration.Integration;
import com.massivecraft.massivecore.integration.IntegrationGlue;
import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.util.Txt;
import com.massivecraft.massivecore.xlib.gson.Gson;
import com.massivecraft.massivecore.xlib.gson.GsonBuilder;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class MassivePlugin
extends JavaPlugin
implements Listener {
    public Gson gson;
    private long timeEnableStart;
    private String logPrefixColored = null;
    private String logPrefixPlain = null;

    public boolean preEnable() {
        this.timeEnableStart = System.currentTimeMillis();
        this.logPrefixColored = Txt.parse("<teal>[<aqua>%s %s<teal>] <i>", this.getDescription().getName(), this.getDescription().getVersion());
        this.logPrefixPlain = ChatColor.stripColor((String)this.logPrefixColored);
        this.log("=== ENABLE START ===");
        this.gson = this.getGsonBuilder().create();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        try {
            MetricsLite metrics = new MetricsLite((Plugin)this);
            metrics.start();
        }
        catch (IOException e) {
            String message = Txt.parse("<b>Metrics Initialization Failed :'(");
            this.log(message);
        }
        return true;
    }

    public void postEnable() {
        this.log(Txt.parse("=== ENABLE <g>COMPLETE <i>(Took <h>" + (System.currentTimeMillis() - this.timeEnableStart) + "ms<i>) ==="));
    }

    public void onEnable() {
        if (!this.preEnable()) {
            return;
        }
        this.postEnable();
    }

    public void onDisable() {
        MassiveCommand.unregister((Plugin)this);
        for (Coll<?> coll : Coll.getInstances()) {
            if (coll.getPlugin() != this) continue;
            coll.deinit();
        }
        this.log("Disabled");
    }

    public GsonBuilder getGsonBuilder() {
        return MassiveCore.getMassiveCoreGsonBuilder();
    }

    public void suicide() {
        this.log(Txt.parse("<b>Now I suicide!"));
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public void integrate(Integration ... features) {
        for (Integration f : features) {
            new IntegrationGlue(this, f);
        }
    }

    public void log(Object ... msg) {
        this.log(Level.INFO, msg);
    }

    public void log(Level level, Object ... msg) {
        String imploded = Txt.implode(msg, " ");
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        if (level == Level.INFO && sender != null) {
            Bukkit.getConsoleSender().sendMessage(this.logPrefixColored + imploded);
        } else {
            Logger.getLogger("Minecraft").log(level, this.logPrefixPlain + imploded);
        }
    }
}

