/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class ModuloRepeatTask
implements Runnable {
    private long delayMillis;
    private long previousMillis;
    private Integer taskId = null;

    public long getDelayMillis() {
        return this.delayMillis;
    }

    public void setDelayMillis(long delayMillis) {
        this.delayMillis = delayMillis;
    }

    public long getPreviousMillis() {
        return this.previousMillis;
    }

    public void setPreviousMillis(long previousMillis) {
        this.previousMillis = previousMillis;
    }

    public long getInvocation(long now) {
        return now / this.getDelayMillis();
    }

    public ModuloRepeatTask() {
        this(0L);
    }

    public ModuloRepeatTask(long delayMilis) {
        this(delayMilis, System.currentTimeMillis());
    }

    public ModuloRepeatTask(long delayMilis, long previousMillis) {
        this.delayMillis = delayMilis;
        this.previousMillis = previousMillis;
    }

    @Override
    public void run() {
        long previousInvocation;
        if (this.getDelayMillis() < 1L) {
            return;
        }
        long nowMillis = System.currentTimeMillis();
        long previousMillis = this.getPreviousMillis();
        long currentInvocation = this.getInvocation(nowMillis);
        if (currentInvocation == (previousInvocation = this.getInvocation(previousMillis))) {
            return;
        }
        this.invoke(nowMillis);
        this.setPreviousMillis(nowMillis);
    }

    @Deprecated
    public int schedule(Plugin plugin) {
        this.activate(plugin);
        return this.taskId;
    }

    public void activate(Plugin plugin) {
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, (Runnable)this, 1L, 1L);
    }

    public void deactivate() {
        if (this.taskId == null) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.taskId.intValue());
    }

    public abstract void invoke(long var1);
}

