/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore;

import com.massivecraft.massivecore.Aspect;
import com.massivecraft.massivecore.AspectColl;
import com.massivecraft.massivecore.MultiverseColl;
import com.massivecraft.massivecore.cmd.arg.ARUniverse;
import com.massivecraft.massivecore.store.Entity;
import com.massivecraft.massivecore.util.MUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Multiverse
extends Entity<Multiverse> {
    protected Map<String, Set<String>> uw = new HashMap<String, Set<String>>();

    public static Multiverse get(Object oid) {
        return (Multiverse)MultiverseColl.get().get(oid);
    }

    public List<Aspect> myAspects() {
        return AspectColl.get().getAllRegisteredForMultiverse(this, true);
    }

    public List<Aspect> otherAspects() {
        return AspectColl.get().getAllRegisteredForMultiverse(this, false);
    }

    public boolean containsUniverse(String universe) {
        return this.getUniverses().contains(universe);
    }

    public Set<String> newUniverse(String universe) {
        if (universe.equals("default")) {
            return null;
        }
        Set<String> ret = this.uw.get(universe);
        if (ret == null) {
            ret = new HashSet<String>();
            this.uw.put(universe, ret);
        }
        return ret;
    }

    public Set<String> delUniverse(String universe) {
        return this.uw.remove(universe);
    }

    public Set<String> getUniverses() {
        TreeSet<String> ret = new TreeSet<String>();
        ret.addAll(this.uw.keySet());
        ret.add("default");
        return ret;
    }

    public String getUniverseForWorldName(String worldName) {
        for (Map.Entry<String, Set<String>> entry : this.uw.entrySet()) {
            String universe = entry.getKey();
            Set<String> worlds = entry.getValue();
            if (!worlds.contains(worldName)) continue;
            return universe;
        }
        return "default";
    }

    public String getUniverse(Object worldNameExtractable) {
        String worldName = MUtil.extract(String.class, "worldName", worldNameExtractable);
        return this.getUniverseForWorldName(worldName);
    }

    public boolean clearUniverse(String universe) {
        Set<String> worlds = this.uw.get(universe);
        if (worlds == null) {
            return false;
        }
        worlds.clear();
        return true;
    }

    public boolean setWorldUniverse(String worldName, String universe) {
        if (this.getUniverseForWorldName(worldName).equals(universe)) {
            return false;
        }
        this.removeWorld(worldName);
        if (!universe.equals("default")) {
            this.newUniverse(universe).add(worldName);
        }
        return true;
    }

    public boolean containsWorld(String worldName) {
        return this.getWorlds().contains(worldName);
    }

    public Set<String> getWorlds() {
        TreeSet<String> ret = new TreeSet<String>();
        for (Set<String> uworlds : this.uw.values()) {
            ret.addAll(uworlds);
        }
        return ret;
    }

    public Set<String> getWorlds(String universe) {
        Set<String> orig = this.uw.get(universe);
        if (orig == null) {
            return null;
        }
        TreeSet<String> ret = new TreeSet<String>();
        ret.addAll(orig);
        return ret;
    }

    public boolean removeWorld(String worldName) {
        for (Set<String> worldNames : this.uw.values()) {
            if (!worldNames.remove(worldName)) continue;
            return true;
        }
        return false;
    }

    public ARUniverse argReaderUniverse() {
        return new ARUniverse(this);
    }
}

