/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore;

import com.massivecraft.massivecore.util.MUtil;
import com.massivecraft.massivecore.util.Txt;
import java.util.Collections;
import java.util.Map;

public class Progressbar {
    public static final transient Progressbar HEALTHBAR_CLASSIC = Progressbar.valueOf(1.0, 30, "{c}[", "|", "&8", "|", "{c}]", 1.0, "{c}", MUtil.map(1.0, "&2", 0.8, "&a", 0.5, "&e", 0.4, "&6", 0.3, "&c", 0.2, "&4"));
    private final double quota;
    private final int width;
    private final String left;
    private final String solid;
    private final String between;
    private final String empty;
    private final String right;
    private final double solidsPerEmpty;
    private final String colorTag;
    private final Map<Double, String> roofToColor;

    public double getQuota() {
        return this.quota;
    }

    public int getWidth() {
        return this.width;
    }

    public String getLeft() {
        return this.left;
    }

    public String getSolid() {
        return this.solid;
    }

    public String getBetween() {
        return this.between;
    }

    public String getEmpty() {
        return this.empty;
    }

    public String getRight() {
        return this.right;
    }

    public double getSolidsPerEmpty() {
        return this.solidsPerEmpty;
    }

    public String getColorTag() {
        return this.colorTag;
    }

    public Map<Double, String> getRoofToColor() {
        return this.roofToColor;
    }

    public Progressbar withQuota(double quota) {
        return new Progressbar(quota, this.width, this.left, this.solid, this.between, this.empty, this.right, this.solidsPerEmpty, this.colorTag, this.roofToColor);
    }

    public Progressbar withWidth(int width) {
        return new Progressbar(this.quota, width, this.left, this.solid, this.between, this.empty, this.right, this.solidsPerEmpty, this.colorTag, this.roofToColor);
    }

    public Progressbar withLeft(String left) {
        return new Progressbar(this.quota, this.width, left, this.solid, this.between, this.empty, this.right, this.solidsPerEmpty, this.colorTag, this.roofToColor);
    }

    public Progressbar solid(String solid) {
        return new Progressbar(this.quota, this.width, this.left, solid, this.between, this.empty, this.right, this.solidsPerEmpty, this.colorTag, this.roofToColor);
    }

    public Progressbar between(String between) {
        return new Progressbar(this.quota, this.width, this.left, this.solid, between, this.empty, this.right, this.solidsPerEmpty, this.colorTag, this.roofToColor);
    }

    public Progressbar empty(String empty) {
        return new Progressbar(this.quota, this.width, this.left, this.solid, this.between, empty, this.right, this.solidsPerEmpty, this.colorTag, this.roofToColor);
    }

    public Progressbar right(String right) {
        return new Progressbar(this.quota, this.width, this.left, this.solid, this.between, this.empty, right, this.solidsPerEmpty, this.colorTag, this.roofToColor);
    }

    public Progressbar solidsPerEmpty(double solidsPerEmpty) {
        return new Progressbar(this.quota, this.width, this.left, this.solid, this.between, this.empty, this.right, solidsPerEmpty, this.colorTag, this.roofToColor);
    }

    public Progressbar colorTag(String colorTag) {
        return new Progressbar(this.quota, this.width, this.left, this.solid, this.between, this.empty, this.right, this.solidsPerEmpty, colorTag, this.roofToColor);
    }

    public Progressbar roofToColor(Map<Double, String> roofToColor) {
        return new Progressbar(this.quota, this.width, this.left, this.solid, this.between, this.empty, this.right, this.solidsPerEmpty, this.colorTag, roofToColor);
    }

    private Progressbar(double quota, int width, String left, String solid, String between, String empty, String right, double solidsPerEmpty, String colorTag, Map<Double, String> roofToColor) {
        this.quota = quota;
        this.width = width;
        this.left = left;
        this.solid = solid;
        this.between = between;
        this.empty = empty;
        this.right = right;
        this.solidsPerEmpty = solidsPerEmpty;
        this.colorTag = colorTag;
        this.roofToColor = Collections.unmodifiableMap(roofToColor);
    }

    public static Progressbar valueOf(double quota, int width, String left, String solid, String between, String empty, String right, double solidsPerEmpty, String colorTag, Map<Double, String> roofToColor) {
        return new Progressbar(quota, width, left, solid, between, empty, right, solidsPerEmpty, colorTag, roofToColor);
    }

    public String render() {
        return Progressbar.render(this.quota, this.width, this.left, this.solid, this.between, this.empty, this.right, this.solidsPerEmpty, this.colorTag, this.roofToColor);
    }

    public static String render(double quota, int width, String left, String solid, String between, String empty, String right, double solidsPerEmpty, String colorTag, Map<Double, String> roofToColor) {
        quota = Progressbar.limit(quota);
        String color = Progressbar.pick(quota, roofToColor);
        int solidCount = (int)Math.ceil((double)width * quota);
        int emptyCount = (int)((double)(width - solidCount) / solidsPerEmpty);
        String ret = left + Txt.repeat(solid, solidCount) + between + Txt.repeat(empty, emptyCount) + right;
        ret = ret.replace(colorTag, color);
        ret = Txt.parse(ret);
        return ret;
    }

    public static double limit(double quota) {
        if (quota > 1.0) {
            return 1.0;
        }
        if (quota < 0.0) {
            return 0.0;
        }
        return quota;
    }

    public static <T> T pick(double quota, Map<Double, T> roofToValue) {
        Double currentRoof = null;
        T ret = null;
        for (Map.Entry<Double, T> entry : roofToValue.entrySet()) {
            double roof = entry.getKey();
            T value = entry.getValue();
            if (!(quota <= roof) || currentRoof != null && !(roof <= currentRoof)) continue;
            currentRoof = roof;
            ret = value;
        }
        return ret;
    }
}

