/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore;

import com.massivecraft.massivecore.cmd.arg.ARSound;
import java.io.Serializable;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public final class SoundEffect
implements Cloneable,
Serializable {
    private static final transient long serialVersionUID = 1L;
    private final Sound sound;
    private final float volume;
    private final float pitch;

    public Sound getSound() {
        return this.sound;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public SoundEffect withSound(Sound sound) {
        return new SoundEffect(sound, this.volume, this.pitch);
    }

    public SoundEffect withVolume(float volume) {
        return new SoundEffect(this.sound, volume, this.pitch);
    }

    public SoundEffect withPitch(float pitch) {
        return new SoundEffect(this.sound, this.volume, pitch);
    }

    private SoundEffect(Sound sound, float volume, float pitch) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    private SoundEffect() {
        this(null, 1.0f, 1.0f);
    }

    public static SoundEffect valueOf(Sound sound, float volume, float pitch) {
        return new SoundEffect(sound, volume, pitch);
    }

    public static SoundEffect valueOf(String soundString) throws Exception {
        if (soundString == null) {
            throw new NullPointerException("soundString was null");
        }
        String[] parts = (soundString = soundString.trim()).split("[^a-zA-Z0-9_.]+");
        Sound sound = ARSound.getSoundFromString(parts[0]);
        if (sound == null) {
            throw new IllegalArgumentException("Unknown sound \"" + parts[0] + "\"");
        }
        float volume = 1.0f;
        if (parts.length >= 2) {
            volume = Float.parseFloat(parts[1]);
        }
        float pitch = 1.0f;
        if (parts.length >= 3) {
            pitch = Float.parseFloat(parts[2]);
        }
        return SoundEffect.valueOf(sound, volume, pitch);
    }

    public void run(Location location) {
        location.getWorld().playSound(location, this.getSound(), this.getVolume(), this.getPitch());
    }

    public void run(Player player, Location location) {
        player.playSound(location, this.getSound(), this.getVolume(), this.getPitch());
    }

    public void run(Player player) {
        this.run(player, player.getEyeLocation());
    }

    public static void runAll(Collection<SoundEffect> soundEffects, Location location) {
        for (SoundEffect soundEffect : soundEffects) {
            soundEffect.run(location);
        }
    }

    public static void runAll(Collection<SoundEffect> soundEffects, Player player, Location location) {
        for (SoundEffect soundEffect : soundEffects) {
            soundEffect.run(player, location);
        }
    }

    public static void runAll(Collection<SoundEffect> soundEffects, Player player) {
        for (SoundEffect soundEffect : soundEffects) {
            soundEffect.run(player);
        }
    }

    public SoundEffect clone() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.pitch);
        result = 31 * result + (this.sound == null ? 0 : this.sound.hashCode());
        result = 31 * result + Float.floatToIntBits(this.volume);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoundEffect)) {
            return false;
        }
        SoundEffect other = (SoundEffect)obj;
        if (Float.floatToIntBits(this.pitch) != Float.floatToIntBits(other.pitch)) {
            return false;
        }
        if (this.sound != other.sound) {
            return false;
        }
        return Float.floatToIntBits(this.volume) == Float.floatToIntBits(other.volume);
    }
}

