/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.adapter;

import com.massivecraft.massivecore.util.MUtil;
import com.massivecraft.massivecore.xlib.gson.JsonArray;
import com.massivecraft.massivecore.xlib.gson.JsonElement;
import com.massivecraft.massivecore.xlib.gson.JsonObject;
import com.massivecraft.massivecore.xlib.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;

public class FireworkEffectAdapter {
    public static final String FLICKER = "flicker";
    public static final String TRAIL = "trail";
    public static final String COLORS = "colors";
    public static final String FADE_COLORS = "fade-colors";
    public static final String TYPE = "type";
    public static final boolean FLICKER_DEFAULT = false;
    public static final boolean TRAIL_DEFAULT = false;
    public static final List<Color> COLORS_DEFAULT = Collections.unmodifiableList(MUtil.list(Color.GREEN));
    public static final List<Color> FADE_COLORS_DEFAULT = Collections.unmodifiableList(new ArrayList());
    public static final FireworkEffect.Type TYPE_DEFAULT = FireworkEffect.Type.BALL_LARGE;

    public static JsonObject toJson(FireworkEffect fireworkEffect) {
        if (fireworkEffect == null) {
            return null;
        }
        JsonObject ret = new JsonObject();
        ret.addProperty(FLICKER, fireworkEffect.hasFlicker());
        ret.addProperty(TRAIL, fireworkEffect.hasTrail());
        ret.add(COLORS, FireworkEffectAdapter.fromColorCollection(fireworkEffect.getColors()));
        ret.add(FADE_COLORS, FireworkEffectAdapter.fromColorCollection(fireworkEffect.getFadeColors()));
        ret.addProperty(TYPE, fireworkEffect.getType().name());
        return ret;
    }

    public static FireworkEffect fromJson(JsonElement jsonElement) {
        if (jsonElement == null) {
            return null;
        }
        if (!jsonElement.isJsonObject()) {
            return null;
        }
        JsonObject json = jsonElement.getAsJsonObject();
        boolean flicker = false;
        boolean trail = false;
        List<Color> colors = COLORS_DEFAULT;
        List<Color> fadeColors = FADE_COLORS_DEFAULT;
        FireworkEffect.Type type = TYPE_DEFAULT;
        JsonElement element = json.get(FLICKER);
        if (element != null) {
            flicker = element.getAsBoolean();
        }
        if ((element = json.get(TRAIL)) != null) {
            trail = element.getAsBoolean();
        }
        if ((element = json.get(COLORS)) != null) {
            colors = FireworkEffectAdapter.toColorCollection(element);
        }
        if ((element = json.get(FADE_COLORS)) != null) {
            fadeColors = FireworkEffectAdapter.toColorCollection(element);
        }
        if ((element = json.get(TYPE)) != null) {
            type = FireworkEffect.Type.valueOf((String)element.getAsString());
        }
        FireworkEffect ret = FireworkEffect.builder().flicker(flicker).trail(trail).withColor(colors).withFade(fadeColors).with(type).build();
        return ret;
    }

    public static JsonArray fromColorCollection(Collection<Color> colors) {
        JsonArray ret = new JsonArray();
        for (Color color : colors) {
            ret.add(new JsonPrimitive(color.asRGB()));
        }
        return ret;
    }

    public static List<Color> toColorCollection(JsonElement json) {
        JsonArray array = json.getAsJsonArray();
        ArrayList<Color> ret = new ArrayList<Color>();
        for (JsonElement element : array) {
            ret.add(Color.fromRGB((int)element.getAsInt()));
        }
        return ret;
    }
}

