/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.adapter;

import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.xlib.gson.JsonDeserializationContext;
import com.massivecraft.massivecore.xlib.gson.JsonDeserializer;
import com.massivecraft.massivecore.xlib.gson.JsonElement;
import com.massivecraft.massivecore.xlib.gson.JsonObject;
import com.massivecraft.massivecore.xlib.gson.JsonParseException;
import com.massivecraft.massivecore.xlib.gson.JsonPrimitive;
import com.massivecraft.massivecore.xlib.gson.JsonSerializationContext;
import com.massivecraft.massivecore.xlib.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryAdapter
implements JsonDeserializer<Inventory>,
JsonSerializer<Inventory> {
    public static final String SIZE = "size";
    public static final String PLAYER = "player";
    public static final String HELMET = "helmet";
    public static final String CHESTPLATE = "chestplate";
    public static final String LEGGINGS = "leggings";
    public static final String BOOTS = "boots";
    private static InventoryAdapter i = new InventoryAdapter();

    public static InventoryAdapter get() {
        return i;
    }

    @Override
    public JsonElement serialize(Inventory src, Type typeOfSrc, JsonSerializationContext context) {
        return InventoryAdapter.toJson(src);
    }

    @Override
    public Inventory deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return InventoryAdapter.fromJson(json);
    }

    public static JsonElement toJson(Inventory src) {
        JsonObject jsonInventory = new JsonObject();
        ItemStack itemStack = null;
        JsonElement jsonItemStack = null;
        ItemStack[] itemStacks = src.getContents();
        if (src instanceof PlayerInventory) {
            jsonInventory.addProperty(SIZE, PLAYER);
            PlayerInventory psrc = (PlayerInventory)src;
            itemStack = psrc.getHelmet();
            if (itemStack != null) {
                jsonItemStack = MassiveCore.gson.toJsonTree(itemStack, (Type)((Object)ItemStack.class));
                jsonInventory.add(HELMET, jsonItemStack);
            }
            if ((itemStack = psrc.getChestplate()) != null) {
                jsonItemStack = MassiveCore.gson.toJsonTree(itemStack, (Type)((Object)ItemStack.class));
                jsonInventory.add(CHESTPLATE, jsonItemStack);
            }
            if ((itemStack = psrc.getLeggings()) != null) {
                jsonItemStack = MassiveCore.gson.toJsonTree(itemStack, (Type)((Object)ItemStack.class));
                jsonInventory.add(LEGGINGS, jsonItemStack);
            }
            if ((itemStack = psrc.getBoots()) != null) {
                jsonItemStack = MassiveCore.gson.toJsonTree(itemStack, (Type)((Object)ItemStack.class));
                jsonInventory.add(BOOTS, jsonItemStack);
            }
        } else {
            jsonInventory.addProperty(SIZE, itemStacks.length);
        }
        for (int i = 0; i < itemStacks.length; ++i) {
            itemStack = itemStacks[i];
            jsonItemStack = MassiveCore.gson.toJsonTree(itemStack, (Type)((Object)ItemStack.class));
            if (jsonItemStack == null) continue;
            jsonInventory.add(String.valueOf(i), jsonItemStack);
        }
        return jsonInventory;
    }

    public static Inventory fromJson(JsonElement json) {
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject jsonInventory = json.getAsJsonObject();
        Inventory ret = null;
        ItemStack itemStack = null;
        JsonElement jsonItemStack = null;
        if (!jsonInventory.has(SIZE)) {
            return null;
        }
        JsonPrimitive jsonSize = jsonInventory.get(SIZE).getAsJsonPrimitive();
        int size = 0;
        if (jsonSize.isString() && jsonSize.getAsString().equals(PLAYER)) {
            size = 36;
            ret = Mixin.createPlayerInventory();
            PlayerInventory pret = (PlayerInventory)ret;
            if (jsonInventory.has(HELMET)) {
                jsonItemStack = jsonInventory.get(HELMET);
                itemStack = MassiveCore.gson.fromJson(jsonItemStack, ItemStack.class);
                pret.setHelmet(itemStack);
            }
            if (jsonInventory.has(CHESTPLATE)) {
                jsonItemStack = jsonInventory.get(CHESTPLATE);
                itemStack = MassiveCore.gson.fromJson(jsonItemStack, ItemStack.class);
                pret.setChestplate(itemStack);
            }
            if (jsonInventory.has(LEGGINGS)) {
                jsonItemStack = jsonInventory.get(LEGGINGS);
                itemStack = MassiveCore.gson.fromJson(jsonItemStack, ItemStack.class);
                pret.setLeggings(itemStack);
            }
            if (jsonInventory.has(BOOTS)) {
                jsonItemStack = jsonInventory.get(BOOTS);
                itemStack = MassiveCore.gson.fromJson(jsonItemStack, ItemStack.class);
                pret.setBoots(itemStack);
            }
        } else {
            size = jsonSize.getAsInt();
            ret = Mixin.createInventory(null, size, null);
        }
        ItemStack[] itemStacks = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            String stackIdx = String.valueOf(i);
            jsonItemStack = jsonInventory.get(stackIdx);
            itemStacks[i] = itemStack = MassiveCore.gson.fromJson(jsonItemStack, ItemStack.class);
        }
        ret.setContents(itemStacks);
        return ret;
    }
}

