/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.adapter;

import com.massivecraft.massivecore.xlib.gson.Gson;
import com.massivecraft.massivecore.xlib.gson.TypeAdapter;
import com.massivecraft.massivecore.xlib.gson.TypeAdapterFactory;
import com.massivecraft.massivecore.xlib.gson.annotations.SerializedName;
import com.massivecraft.massivecore.xlib.gson.reflect.TypeToken;
import com.massivecraft.massivecore.xlib.gson.stream.JsonReader;
import com.massivecraft.massivecore.xlib.gson.stream.JsonToken;
import com.massivecraft.massivecore.xlib.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class ModdedEnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    private final Map<String, T> nameToConstant = new HashMap<String, T>();
    private final Map<T, String> constantToName = new HashMap<T, String>();
    public static final TypeAdapterFactory ENUM_FACTORY = ModdedEnumTypeAdapter.newEnumTypeHierarchyFactory();

    public ModdedEnumTypeAdapter(Class<T> classOfT) {
        for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
            String name = constant.name();
            try {
                SerializedName annotation = classOfT.getField(name).getAnnotation(SerializedName.class);
                if (annotation != null) {
                    name = annotation.value();
                }
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
            this.nameToConstant.put(name, constant);
            this.constantToName.put(constant, name);
        }
    }

    @Override
    public T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return (T)((Enum)this.nameToConstant.get(in.nextString()));
    }

    @Override
    public void write(JsonWriter out, T value) throws IOException {
        out.value(value == null ? null : this.constantToName.get(value));
    }

    public static <TT> TypeAdapterFactory newEnumTypeHierarchyFactory() {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> rawType = typeToken.getRawType();
                if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                    return null;
                }
                if (!rawType.isEnum()) {
                    rawType = rawType.getSuperclass();
                }
                return new ModdedEnumTypeAdapter<T>(rawType);
            }
        };
    }
}

