/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.adapter;

import com.massivecraft.massivecore.xlib.gson.JsonDeserializationContext;
import com.massivecraft.massivecore.xlib.gson.JsonDeserializer;
import com.massivecraft.massivecore.xlib.gson.JsonElement;
import com.massivecraft.massivecore.xlib.gson.JsonParseException;
import com.massivecraft.massivecore.xlib.gson.JsonPrimitive;
import com.massivecraft.massivecore.xlib.gson.JsonSerializationContext;
import com.massivecraft.massivecore.xlib.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;

public class UUIDAdapter
implements JsonDeserializer<UUID>,
JsonSerializer<UUID> {
    private static UUIDAdapter i = new UUIDAdapter();

    public static UUIDAdapter get() {
        return i;
    }

    @Override
    public JsonElement serialize(UUID src, Type typeOfSrc, JsonSerializationContext context) {
        return UUIDAdapter.convertUUIDToJsonPrimitive(src);
    }

    @Override
    public UUID deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return UUIDAdapter.convertJsonElementToUUID(json);
    }

    public static String convertUUIDToString(UUID uuid) {
        return uuid.toString();
    }

    public static JsonPrimitive convertUUIDToJsonPrimitive(UUID uuid) {
        return new JsonPrimitive(UUIDAdapter.convertUUIDToString(uuid));
    }

    public static UUID convertStringToUUID(String string) {
        return UUID.fromString(string);
    }

    public static UUID convertJsonElementToUUID(JsonElement jsonElement) {
        return UUIDAdapter.convertStringToUUID(jsonElement.getAsString());
    }
}

