/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd;

import com.massivecraft.massivecore.cmd.MassiveCommand;
import com.massivecraft.massivecore.cmd.arg.ARInteger;
import com.massivecraft.massivecore.util.Txt;
import java.util.ArrayList;

public class HelpCommand
extends MassiveCommand {
    private static HelpCommand i = new HelpCommand();

    public static HelpCommand get() {
        return i;
    }

    private HelpCommand() {
        this.addAliases("?", "h", "help");
        this.setDesc("");
        this.addOptionalArg("page", "1");
    }

    @Override
    public void perform() {
        if (this.getCommandChain().size() == 0) {
            return;
        }
        MassiveCommand parentCommand = this.getCommandChain().get(this.getCommandChain().size() - 1);
        ArrayList<String> lines = new ArrayList<String>();
        for (String helpline : parentCommand.getHelp()) {
            lines.add(Txt.parse("<a>#<i> " + helpline));
        }
        for (MassiveCommand subCommand : parentCommand.getSubCommands()) {
            if (!subCommand.isVisibleTo(this.sender)) continue;
            lines.add(subCommand.getUseageTemplate(this.getCommandChain(), true, true, this.sender));
        }
        Integer pagenumber = this.arg(0, ARInteger.get(), Integer.valueOf(1));
        if (pagenumber == null) {
            return;
        }
        this.sendMessage(Txt.getPage(lines, (int)pagenumber, "Help for command \"" + parentCommand.getAliases().get(0) + "\"", this.sender));
    }
}

