/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd;

import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.cmd.HelpCommand;
import com.massivecraft.massivecore.cmd.VisibilityMode;
import com.massivecraft.massivecore.cmd.arg.ArgReader;
import com.massivecraft.massivecore.cmd.arg.ArgResult;
import com.massivecraft.massivecore.cmd.req.Req;
import com.massivecraft.massivecore.cmd.req.ReqHasPerm;
import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.util.PermUtil;
import com.massivecraft.massivecore.util.Txt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MassiveCommand {
    private static transient Map<MassiveCommand, Plugin> registry = new LinkedHashMap<MassiveCommand, Plugin>();
    protected List<MassiveCommand> subCommands;
    protected List<String> aliases;
    protected List<String> requiredArgs;
    protected Map<String, String> optionalArgs;
    protected boolean errorOnToManyArgs = true;
    protected boolean usingTokenizer = true;
    protected boolean usingSmartQuotesRemoval = true;
    protected List<Req> requirements;
    protected String desc = null;
    protected String descPermission = null;
    protected List<String> help = new ArrayList<String>();
    protected VisibilityMode visibilityMode;
    protected List<String> args;
    protected List<MassiveCommand> commandChain = new ArrayList<MassiveCommand>();
    public CommandSender sender;
    public Player me;
    public boolean senderIsConsole;

    public static Set<MassiveCommand> getRegisteredCommands() {
        return registry.keySet();
    }

    public static Map<MassiveCommand, Plugin> getRegistry() {
        return registry;
    }

    public static void unregister(Plugin plugin) {
        Iterator<Map.Entry<MassiveCommand, Plugin>> iter = registry.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<MassiveCommand, Plugin> entry = iter.next();
            if (!plugin.equals(entry.getValue())) continue;
            iter.remove();
        }
    }

    @Deprecated
    public void register() {
        this.register((Plugin)MassiveCore.get());
    }

    public Plugin register(Plugin plugin) {
        return registry.put(this, plugin);
    }

    public void unregister() {
        registry.remove(this);
    }

    public boolean isRegistered() {
        return registry.containsKey(this);
    }

    public Plugin getRegisteredPlugin() {
        return registry.get(this);
    }

    public List<MassiveCommand> getSubCommands() {
        return this.subCommands;
    }

    public void setSubCommands(List<MassiveCommand> subCommands) {
        this.subCommands = subCommands;
    }

    public void addSubCommand(MassiveCommand subCommand) {
        this.addSubCommand(subCommand, this.subCommands.size());
    }

    public void addSubCommand(MassiveCommand subCommand, int index) {
        subCommand.commandChain.addAll(this.commandChain);
        subCommand.commandChain.add(this);
        this.subCommands.add(index, subCommand);
    }

    public void addSubCommandAfter(MassiveCommand subCommand, MassiveCommand after) {
        int index = this.subCommands.indexOf(after);
        index = index == -1 ? this.subCommands.size() : ++index;
        this.addSubCommand(subCommand, index);
    }

    public int removeSubCommand(MassiveCommand subCommand) {
        int index = this.subCommands.indexOf(subCommand);
        this.subCommands.remove(index);
        return index;
    }

    public int replaceSubCommand(MassiveCommand subCommand, MassiveCommand replaced) {
        int index = this.removeSubCommand(replaced);
        if (index < 0) {
            return index;
        }
        this.addSubCommand(subCommand, index);
        return index;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public void addAliases(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
    }

    public void addAliases(List<String> aliases) {
        this.aliases.addAll(aliases);
    }

    public List<String> getRequiredArgs() {
        return this.requiredArgs;
    }

    public void setRequiredArgs(List<String> requiredArgs) {
        this.requiredArgs = requiredArgs;
    }

    public void addRequiredArg(String arg) {
        this.requiredArgs.add(arg);
    }

    public Map<String, String> getOptionalArgs() {
        return this.optionalArgs;
    }

    public void setOptionalArgs(Map<String, String> optionalArgs) {
        this.optionalArgs = optionalArgs;
    }

    public void addOptionalArg(String arg, String def) {
        this.optionalArgs.put(arg, def);
    }

    public boolean getErrorOnToManyArgs() {
        return this.errorOnToManyArgs;
    }

    public void setErrorOnToManyArgs(boolean val) {
        this.errorOnToManyArgs = val;
    }

    public boolean isUsingTokenizer() {
        return this.usingTokenizer;
    }

    public void setUsingTokenizer(boolean usingTokenizer) {
        this.usingTokenizer = usingTokenizer;
    }

    public boolean isUsingSmartQuotesRemoval() {
        return this.usingSmartQuotesRemoval;
    }

    public void setUsingSmartQuotesRemoval(boolean usingSmartQuotesRemoval) {
        this.usingSmartQuotesRemoval = usingSmartQuotesRemoval;
    }

    public List<Req> getRequirements() {
        return this.requirements;
    }

    public void getRequirements(List<Req> requirements) {
        this.requirements = requirements;
    }

    public void addRequirements(Req ... requirements) {
        this.requirements.addAll(Arrays.asList(requirements));
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        String pdesc;
        if (this.desc != null) {
            return this.desc;
        }
        String perm = this.getDescPermission();
        if (perm != null && (pdesc = PermUtil.getDescription(this.getDescPermission())) != null) {
            return pdesc;
        }
        return "*info unavailable*";
    }

    public void setDescPermission(String descPermission) {
        this.descPermission = descPermission;
    }

    public String getDescPermission() {
        if (this.descPermission != null) {
            return this.descPermission;
        }
        for (Req req : this.getRequirements()) {
            if (!(req instanceof ReqHasPerm)) continue;
            return ((ReqHasPerm)req).getPerm();
        }
        return null;
    }

    public void setHelp(List<String> val) {
        this.help = val;
    }

    public void setHelp(String ... val) {
        this.help = Arrays.asList(val);
    }

    public List<String> getHelp() {
        return this.help;
    }

    public VisibilityMode getVisibilityMode() {
        return this.visibilityMode;
    }

    public void setVisibilityMode(VisibilityMode visibilityMode) {
        this.visibilityMode = visibilityMode;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public List<MassiveCommand> getCommandChain() {
        return this.commandChain;
    }

    public void setCommandChain(List<MassiveCommand> commandChain) {
        this.commandChain = commandChain;
    }

    public MassiveCommand() {
        this.subCommands = new ArrayList<MassiveCommand>();
        this.aliases = new ArrayList<String>();
        this.requiredArgs = new ArrayList<String>();
        this.optionalArgs = new LinkedHashMap<String, String>();
        this.requirements = new ArrayList<Req>();
        this.visibilityMode = VisibilityMode.VISIBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandSender sender, List<String> args, List<MassiveCommand> commandChain) {
        this.setArgs(args);
        this.setCommandChain(commandChain);
        if (args.size() > 0) {
            for (MassiveCommand subCommand : this.getSubCommands()) {
                for (String alias : subCommand.getAliases()) {
                    if (!args.get(0).equalsIgnoreCase(alias)) continue;
                    args.remove(0);
                    commandChain.add(this);
                    subCommand.execute(sender, args, commandChain);
                    return;
                }
            }
        }
        try {
            this.sender = sender;
            this.senderIsConsole = true;
            this.me = null;
            if (sender instanceof Player) {
                this.me = (Player)sender;
                this.senderIsConsole = false;
            }
            this.fixSenderVars();
            if (!this.isValidCall(this.sender, this.getArgs())) {
                return;
            }
            this.perform();
        }
        finally {
            this.sender = null;
            this.me = null;
            this.unsetSenderVars();
        }
    }

    public void fixSenderVars() {
    }

    public void unsetSenderVars() {
    }

    public void execute(CommandSender sender, List<String> args) {
        this.execute(sender, args, new ArrayList<MassiveCommand>());
    }

    public void perform() {
        ArrayList<MassiveCommand> commandChain = new ArrayList<MassiveCommand>(this.getCommandChain());
        commandChain.add(this);
        HelpCommand.get().execute(this.sender, this.getArgs(), commandChain);
    }

    public boolean isValidCall(CommandSender sender, List<String> args) {
        if (!this.isRequirementsMet(sender, true)) {
            return false;
        }
        return this.isArgsValid(args, sender);
    }

    public boolean isVisibleTo(CommandSender sender) {
        if (this.getVisibilityMode() == VisibilityMode.VISIBLE) {
            return true;
        }
        if (this.getVisibilityMode() == VisibilityMode.INVISIBLE) {
            return false;
        }
        return this.isRequirementsMet(sender, false);
    }

    public boolean isRequirementsMet(CommandSender sender, boolean informSenderIfNot) {
        for (Req req : this.getRequirements()) {
            if (req.apply(sender, this)) continue;
            if (informSenderIfNot) {
                this.msg(req.createErrorMessage(sender, this));
            }
            return false;
        }
        return true;
    }

    public boolean isArgsValid(List<String> args, CommandSender sender) {
        if (args.size() < this.getRequiredArgs().size()) {
            if (sender != null) {
                this.msg("<b>To few arguments. <i>Use like this:");
                sender.sendMessage(this.getUseageTemplate());
            }
            return false;
        }
        if (args.size() > this.getRequiredArgs().size() + this.getOptionalArgs().size() && this.getErrorOnToManyArgs()) {
            if (sender != null) {
                List<String> theToMany = args.subList(this.getRequiredArgs().size() + this.optionalArgs.size(), args.size());
                this.msg("<b>Strange arguments %s<b>.", Txt.implodeCommaAndDot(theToMany, Txt.parse("<aqua>%s"), Txt.parse("<b>, "), Txt.parse("<b> and "), ""));
                this.msg("<i>Use the command like this:");
                sender.sendMessage(this.getUseageTemplate());
            }
            return false;
        }
        return true;
    }

    public boolean isArgsValid(List<String> args) {
        return this.isArgsValid(args, null);
    }

    public String getUseageTemplate(List<MassiveCommand> commandChain, boolean addDesc, boolean onlyFirstAlias, CommandSender sender) {
        StringBuilder ret = new StringBuilder();
        ArrayList<MassiveCommand> commands = new ArrayList<MassiveCommand>(commandChain);
        commands.add(this);
        String commandGoodColor = Txt.parse("<c>");
        String commandBadColor = Txt.parse("<bad>");
        ret.append(commandGoodColor);
        ret.append('/');
        boolean first = true;
        Iterator iter = commands.iterator();
        while (iter.hasNext()) {
            MassiveCommand mc = (MassiveCommand)iter.next();
            if (sender != null && !mc.isRequirementsMet(sender, false)) {
                ret.append(commandBadColor);
            } else {
                ret.append(commandGoodColor);
            }
            if (first && onlyFirstAlias) {
                ret.append(mc.getAliases().get(0));
            } else {
                ret.append(Txt.implode(mc.getAliases(), ","));
            }
            if (iter.hasNext()) {
                ret.append(' ');
            }
            first = false;
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String string : this.getRequiredArgs()) {
            args.add("<" + string + ">");
        }
        for (Map.Entry entry : this.getOptionalArgs().entrySet()) {
            String val = (String)entry.getValue();
            val = val == null ? "" : "=" + val;
            args.add("[" + (String)entry.getKey() + val + "]");
        }
        if (args.size() > 0) {
            ret.append(Txt.parse("<p>"));
            ret.append(' ');
            ret.append(Txt.implode(args, " "));
        }
        if (addDesc) {
            ret.append(' ');
            ret.append(Txt.parse("<i>"));
            ret.append(this.getDesc());
        }
        return ret.toString();
    }

    public String getUseageTemplate(List<MassiveCommand> commandChain, boolean addDesc, boolean onlyFirstAlias) {
        return this.getUseageTemplate(commandChain, addDesc, onlyFirstAlias, null);
    }

    public String getUseageTemplate(List<MassiveCommand> commandChain, boolean addDesc) {
        return this.getUseageTemplate(commandChain, addDesc, false);
    }

    public String getUseageTemplate(boolean addDesc) {
        return this.getUseageTemplate(this.getCommandChain(), addDesc);
    }

    public String getUseageTemplate() {
        return this.getUseageTemplate(false);
    }

    public boolean sendMessage(String message) {
        return Mixin.messageOne((Object)this.sender, message);
    }

    public boolean sendMessage(String ... messages) {
        return Mixin.messageOne((Object)this.sender, messages);
    }

    public boolean sendMessage(Collection<String> messages) {
        return Mixin.messageOne((Object)this.sender, messages);
    }

    public boolean msg(String msg) {
        return Mixin.msgOne((Object)this.sender, msg);
    }

    public boolean msg(String msg, Object ... args) {
        return Mixin.msgOne(this.sender, msg, args);
    }

    public boolean msg(Collection<String> msgs) {
        return Mixin.msgOne((Object)this.sender, msgs);
    }

    public boolean argIsSet(int idx) {
        return this.args.size() >= idx + 1;
    }

    public String arg(int idx) {
        if (!this.argIsSet(idx)) {
            return null;
        }
        return this.getArgs().get(idx);
    }

    public <T> T arg(int idx, ArgReader<T> argReader) {
        String str = this.arg(idx);
        return this.arg(str, argReader);
    }

    public <T> T arg(int idx, ArgReader<T> argReader, T defaultNotSet) {
        String str = this.arg(idx);
        return this.arg(str, argReader, defaultNotSet);
    }

    public String argConcatFrom(int idx) {
        if (!this.argIsSet(idx)) {
            return null;
        }
        int from = idx;
        int to = this.getArgs().size();
        if (to <= from) {
            return "";
        }
        return Txt.implode(this.getArgs().subList(from, to), " ");
    }

    public <T> T argConcatFrom(int idx, ArgReader<T> argReader) {
        String str = this.argConcatFrom(idx);
        return this.arg(str, argReader);
    }

    public <T> T argConcatFrom(int idx, ArgReader<T> argReader, T defaultNotSet) {
        String str = this.argConcatFrom(idx);
        return this.arg(str, argReader, defaultNotSet);
    }

    public <T> T arg(ArgReader<T> argReader) {
        return this.arg(null, argReader);
    }

    public <T> T arg(String str, ArgReader<T> argReader) {
        ArgResult<T> result = argReader.read(str, this.sender);
        if (result.hasErrors()) {
            this.msg(result.getErrors());
        }
        return result.getResult();
    }

    public <T> T arg(String str, ArgReader<T> argReader, T defaultNotSet) {
        if (str == null) {
            return defaultNotSet;
        }
        return this.arg(str, argReader);
    }
}

