/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd;

import com.massivecraft.massivecore.cmd.MassiveCommand;
import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.util.IdUtil;
import com.massivecraft.massivecore.util.Txt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class MassiveCoreBukkitCommand
extends Command {
    private final MassiveCommand massiveCommand;

    public MassiveCommand getMassiveCommand() {
        return this.massiveCommand;
    }

    public MassiveCoreBukkitCommand(String name, MassiveCommand massiveCommand) {
        super(name, massiveCommand.getDesc(), massiveCommand.getUseageTemplate(), new ArrayList());
        this.massiveCommand = massiveCommand;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        List<String> argList = this.massiveCommand.isUsingTokenizer() ? Txt.tokenizeArguments(Txt.implode(args, " ")) : new ArrayList<String>(Arrays.asList(args));
        if (this.massiveCommand.isUsingSmartQuotesRemoval()) {
            List<String> oldArgList = argList;
            argList = new ArrayList<String>();
            for (String arg : oldArgList) {
                argList.add(Txt.removeSmartQuotes(arg));
            }
        }
        this.massiveCommand.execute(sender, argList);
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        List superRet = super.tabComplete(sender, alias, args);
        if (args.length == 0) {
            return superRet;
        }
        TreeSet<String> ret = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        ret.addAll(superRet);
        String tokenlc = args[args.length - 1].toLowerCase();
        for (String senderName : IdUtil.getOnlineNames()) {
            if (!senderName.toLowerCase().startsWith(tokenlc) || !Mixin.canSee(sender, senderName)) continue;
            ret.add(senderName);
        }
        return new ArrayList<String>(ret);
    }
}

