/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd.arg;

import com.massivecraft.massivecore.cmd.arg.ARAbstractSelect;
import com.massivecraft.massivecore.util.Txt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.command.CommandSender;

public class AREnum<T>
extends ARAbstractSelect<T> {
    private final Class<T> clazz;

    public static <T> AREnum<T> get(Class<T> clazz) {
        return new AREnum<T>(clazz);
    }

    public AREnum(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public String typename() {
        return Txt.getNicedEnumString(this.clazz.getSimpleName());
    }

    @Override
    public T select(String arg, CommandSender sender) {
        if (arg == null) {
            return null;
        }
        arg = AREnum.getComparable(arg);
        int startswithCount = 0;
        T startswith = null;
        for (T value : AREnum.getEnumValues(this.clazz)) {
            String comparable = AREnum.getComparable(value.toString());
            if (comparable.equals(arg)) {
                return value;
            }
            if (!comparable.startsWith(arg)) continue;
            startswith = value;
            ++startswithCount;
        }
        if (startswithCount == 1) {
            return startswith;
        }
        return null;
    }

    @Override
    public Collection<String> altNames(CommandSender sender) {
        ArrayList<String> ret = new ArrayList<String>();
        for (T value : AREnum.getEnumValues(this.clazz)) {
            ret.add(AREnum.getComparable(value.toString()));
        }
        return ret;
    }

    public static String getComparable(String string) {
        return string.toLowerCase().replaceAll("[_\\-\\s]+", "");
    }

    public static <T> T[] getEnumValues(Class<T> clazz) {
        try {
            Method method = clazz.getMethod("values", new Class[0]);
            Object o = method.invoke(null, new Object[0]);
            return (Object[])o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

