/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd.arg;

import com.massivecraft.massivecore.cmd.arg.ArgReaderAbstract;
import com.massivecraft.massivecore.cmd.arg.ArgResult;
import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.store.SenderIdSource;
import com.massivecraft.massivecore.util.IdUtil;
import java.util.Collection;
import org.bukkit.command.CommandSender;

public abstract class ARSenderIdAbstract<T>
extends ArgReaderAbstract<T> {
    private final SenderIdSource source;
    private final boolean online;

    public ARSenderIdAbstract(SenderIdSource source, boolean online) {
        this.source = source;
        this.online = online;
    }

    public ARSenderIdAbstract(SenderIdSource source) {
        this(source, false);
    }

    public abstract T getResultForSenderId(String var1);

    @Override
    public ArgResult<T> read(String arg, CommandSender sender) {
        ArgResult<T> ret = new ArgResult<T>();
        String senderId = this.getSenderIdFor(arg);
        if (senderId == null) {
            ret.setErrors("<b>No player matches \"<h>" + arg + "<b>\".");
        } else {
            ret.setResult(this.getResultForSenderId(senderId));
        }
        return ret;
    }

    public String getSenderIdFor(String arg) {
        String senderId = arg.toLowerCase();
        String betterId = IdUtil.getId(senderId);
        if (betterId != null) {
            senderId = betterId;
        }
        for (Collection<String> coll : this.source.getSenderIdCollections()) {
            T result;
            if (!coll.contains(senderId) || this.online && !Mixin.isOnline(senderId) || (result = this.getResultForSenderId(senderId)) == null) continue;
            return senderId;
        }
        return null;
    }
}

