/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd.arg;

import com.massivecraft.massivecore.cmd.arg.ARAbstractSelect;
import com.massivecraft.massivecore.mixin.Mixin;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public class ARWorldId
extends ARAbstractSelect<String> {
    private static ARWorldId i = new ARWorldId();

    public static ARWorldId get() {
        return i;
    }

    @Override
    public String typename() {
        return "world";
    }

    @Override
    public String select(String arg, CommandSender sender) {
        List<String> visibleWorldIds = Mixin.getVisibleWorldIds((Permissible)sender);
        for (String worldId : visibleWorldIds) {
            if (!Mixin.canSeeWorld((Permissible)sender, worldId) || !arg.equalsIgnoreCase(worldId)) continue;
            return worldId;
        }
        for (String worldId : visibleWorldIds) {
            if (!Mixin.canSeeWorld((Permissible)sender, worldId)) continue;
            for (String worldAlias : Mixin.getWorldAliases(worldId)) {
                if (!arg.equalsIgnoreCase(worldAlias)) continue;
                return worldId;
            }
        }
        return null;
    }

    public List<String> altNames(CommandSender sender) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String worldId : Mixin.getWorldIds()) {
            if (!Mixin.canSeeWorld((Permissible)sender, worldId)) continue;
            ret.add(Mixin.getWorldDisplayName(worldId));
        }
        return ret;
    }
}

