/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd.massivecore;

import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.MassiveCorePerm;
import com.massivecraft.massivecore.cmd.MassiveCommand;
import com.massivecraft.massivecore.cmd.req.ReqHasPerm;
import com.massivecraft.massivecore.cmd.req.ReqIsPlayer;
import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.util.WebUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CmdMassiveCoreCmdurl
extends MassiveCommand {
    public CmdMassiveCoreCmdurl() {
        this.addAliases("cmdurl");
        this.addRequiredArg("url");
        this.addRequirements(ReqHasPerm.get(MassiveCorePerm.CMDURL.node));
        this.addRequirements(ReqIsPlayer.get());
    }

    @Override
    public void perform() {
        URL url;
        String urlString = this.arg(0);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            this.msg("<b>Malformed URL: %s", e.getMessage());
            return;
        }
        final Player commander = this.me;
        this.msg("<i>Loading <aqua>%s <i>...", urlString);
        CmdMassiveCoreCmdurl.async(new Runnable(){

            @Override
            public void run() {
                try {
                    final List<String> lines = WebUtil.getUrlLines(url, 5000);
                    CmdMassiveCoreCmdurl.sync(new Runnable(){

                        @Override
                        public void run() {
                            Mixin.msgOne(commander, "<i>... <h>%d <i>lines loaded. Now executing ...", lines.size());
                            for (int i = 0; i <= lines.size() - 1; ++i) {
                                String line = (String)lines.get(i);
                                if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
                                    Mixin.msgOne(commander, "<b>#%d: <i>%s", i, line);
                                    continue;
                                }
                                Mixin.msgOne(commander, "<g>#%d: <i>%s", i, line);
                                commander.chat(line);
                            }
                        }
                    });
                    return;
                }
                catch (Exception e) {
                    CmdMassiveCoreCmdurl.sync(new Runnable(){

                        @Override
                        public void run() {
                            Mixin.msgOne(commander, "<b>%s: %s", e.getClass().getSimpleName(), e.getMessage());
                        }
                    });
                    return;
                }
            }
        });
    }

    public static void sync(Runnable runnable) {
        Bukkit.getScheduler().runTask((Plugin)MassiveCore.get(), runnable);
    }

    public static void async(Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)MassiveCore.get(), runnable);
    }
}

