/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd.massivecore;

import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.MassiveCorePerm;
import com.massivecraft.massivecore.cmd.MassiveCommand;
import com.massivecraft.massivecore.cmd.req.ReqHasPerm;
import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.store.Db;
import com.massivecraft.massivecore.store.Driver;
import com.massivecraft.massivecore.store.MStore;
import com.massivecraft.massivecore.xlib.gson.JsonElement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.bukkit.plugin.Plugin;

public class CmdMassiveCoreStoreCopydb
extends MassiveCommand {
    public CmdMassiveCoreStoreCopydb() {
        this.addAliases("copydb");
        this.addRequiredArg("from");
        this.addRequiredArg("to");
        this.addRequirements(ReqHasPerm.get(MassiveCorePerm.STORE_COPYDB.node));
    }

    @Override
    public void perform() {
        String fromAlias = this.arg(0);
        Db fromDb = MStore.getDb(fromAlias);
        if (fromDb == null) {
            this.msg("<b>could not get the from-database.");
            return;
        }
        String toAlias = this.arg(1);
        Db toDb = MStore.getDb(toAlias);
        if (toDb == null) {
            this.msg("<b>could not get the to-database.");
            return;
        }
        Driver fromDriver = fromDb.getDriver();
        Driver toDriver = toDb.getDriver();
        Set<String> collnames = fromDb.getCollnames();
        int countCollCurrent = 0;
        int countCollTotal = collnames.size();
        long before = System.currentTimeMillis();
        this.msg("<i>Now copying database with <h>%d <i>collections.", countCollTotal);
        for (String collname : fromDb.getCollnames()) {
            Coll<Object> fromColl = new Coll<Object>(collname, Object.class, fromDb, (Plugin)MassiveCore.get());
            Coll<Object> toColl = new Coll<Object>(collname, Object.class, toDb, (Plugin)MassiveCore.get());
            Collection<String> ids = fromDriver.getIds(fromColl);
            this.msg("<i>Now copying collection <h>%d/%d %s <i>with <h>%d <i>documents.", ++countCollCurrent, countCollTotal, collname, ids.size());
            if (ids.size() > 0 && fromDriver.load(fromColl, ids.iterator().next()) == null) {
                this.msg("<b>Skipping <h>%s <b>since could not load data.", collname);
                continue;
            }
            for (String id : ids) {
                Map.Entry<JsonElement, Long> data = fromDriver.load(fromColl, id);
                toDriver.save(toColl, id, data.getKey());
            }
        }
        long after = System.currentTimeMillis();
        long duration = after - before;
        this.msg("<g>The copy is now complete. <i>It took <h>%dms<i>.", duration);
    }
}

