/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd.massivecore;

import com.massivecraft.massivecore.ConfServer;
import com.massivecraft.massivecore.MassiveCorePerm;
import com.massivecraft.massivecore.NaturalOrderComparator;
import com.massivecraft.massivecore.cmd.MassiveCommand;
import com.massivecraft.massivecore.cmd.arg.ARString;
import com.massivecraft.massivecore.cmd.req.ReqHasPerm;
import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.store.Db;
import com.massivecraft.massivecore.store.MStore;
import com.massivecraft.massivecore.util.Txt;
import java.util.TreeSet;

public class CmdMassiveCoreStoreListcolls
extends MassiveCommand {
    public CmdMassiveCoreStoreListcolls() {
        this.addAliases("listcolls");
        this.addOptionalArg("db", ConfServer.dburi);
        this.addRequirements(ReqHasPerm.get(MassiveCorePerm.STORE_LISTCOLLS.node));
    }

    @Override
    public void perform() {
        String dbAlias = this.arg(0, ARString.get(), ConfServer.dburi);
        Db db = MStore.getDb(dbAlias);
        if (db == null) {
            this.msg("<b>could not get the database.");
            return;
        }
        TreeSet<Object> collnames = new TreeSet<Object>(NaturalOrderComparator.get());
        collnames.addAll(db.getCollnames());
        this.msg(Txt.titleize("Collections in " + db.getName()));
        for (String string : collnames) {
            String message = Txt.parse("<h>") + string;
            Coll<?> coll = null;
            for (Coll<?> collCandidate : Coll.getInstances()) {
                if (!collCandidate.getName().equals(string) || collCandidate.getDb() != db) continue;
                coll = collCandidate;
                break;
            }
            message = coll == null ? message + Txt.parse(" <b>UNUSED") : message + Txt.parse(" <i>(%d documents)", coll.getIds().size());
            this.sendMessage(message);
        }
    }
}

