/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd.massivecore;

import com.massivecraft.massivecore.MassiveCorePerm;
import com.massivecraft.massivecore.cmd.MassiveCommand;
import com.massivecraft.massivecore.cmd.arg.ARColl;
import com.massivecraft.massivecore.cmd.req.ReqHasPerm;
import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.store.ExamineThread;
import com.massivecraft.massivecore.util.MUtil;
import com.massivecraft.massivecore.util.Txt;
import java.util.Map;

public class CmdMassiveCoreStoreStats
extends MassiveCommand {
    public CmdMassiveCoreStoreStats() {
        this.addAliases("stats");
        this.addOptionalArg("coll", "*total*");
        this.addRequirements(ReqHasPerm.get(MassiveCorePerm.STORE_STATS.node));
    }

    @Override
    public void perform() {
        if (!this.argIsSet(0) || this.arg(0).equalsIgnoreCase("*total*")) {
            this.performTotal();
        } else {
            Coll coll = (Coll)this.arg(0, ARColl.get());
            if (coll == null) {
                return;
            }
            this.performColl(coll);
        }
    }

    public void performTotal() {
        this.msg(Txt.titleize("MStore Total Statistics"));
        this.msg("<k>Last Examine Duration: <v>%d<i>ms", ExamineThread.get().getLastDurationMillis());
        this.msg("<a>== <k>Coll <a>| <k>Sync Count In <a>| <k>Sync Count Out <a>==");
        for (Map.Entry<String, Coll<?>> entry : Coll.getMap().entrySet()) {
            String name = entry.getKey();
            Coll<?> coll = entry.getValue();
            long in = coll.getSyncCount("*total*", true);
            long out = coll.getSyncCount("*total*", false);
            this.msg("<v>%s <a>| <v>%d <a>| <v>%d", name, in, out);
        }
    }

    public void performColl(Coll<?> coll) {
        this.msg(Txt.titleize("MStore " + coll.getName() + " Statistics"));
        this.msg("<k>Basename: <v>%s", coll.getBasename());
        this.msg("<k>Universe: <v>%s", coll.getUniverse());
        this.msg("<k>Entity Count: <v>%d", coll.getIds().size());
        this.msg("<k>Entity Class: <v>%s", coll.getEntityClass().getName());
        this.msg("<k>Plugin: <v>%s", coll.getPlugin().getDescription().getFullName());
        this.msg("<k>Database: <v>%s", coll.getDb().getName());
        this.msg("<k>Driver: <v>%s", coll.getDriver().getName());
        this.msg("<a>== Sync Count In <a>==");
        int limit = 30;
        for (Map.Entry entry : MUtil.entriesSortedByValues(coll.getSyncMap(true), false)) {
            if (limit-- == 0) break;
            this.msg("<k>%s <v>%d", entry.getKey(), entry.getValue());
        }
        this.msg("<a>== Sync Count Out <a>==");
        limit = 30;
        for (Map.Entry entry : MUtil.entriesSortedByValues(coll.getSyncMap(false), false)) {
            if (limit-- == 0) break;
            this.msg("<k>%s <v>%d", entry.getKey(), entry.getValue());
        }
    }
}

