/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.cmd.massivecore;

import com.massivecraft.massivecore.Aspect;
import com.massivecraft.massivecore.MassiveCorePerm;
import com.massivecraft.massivecore.Multiverse;
import com.massivecraft.massivecore.cmd.MassiveCommand;
import com.massivecraft.massivecore.cmd.arg.ARMultiverse;
import com.massivecraft.massivecore.cmd.req.ReqHasPerm;
import com.massivecraft.massivecore.util.Txt;
import java.util.ArrayList;
import java.util.List;

public class CmdMassiveCoreUsysMultiverseShow
extends MassiveCommand {
    public CmdMassiveCoreUsysMultiverseShow() {
        this.addAliases("s", "show");
        this.addRequiredArg("multiverse");
        this.addRequirements(ReqHasPerm.get(MassiveCorePerm.USYS_MULTIVERSE_SHOW.node));
    }

    @Override
    public void perform() {
        Multiverse multiverse = this.arg(0, ARMultiverse.get());
        if (multiverse == null) {
            return;
        }
        this.msg(Txt.titleize("Multiverse: " + multiverse.getId()));
        for (String universe : multiverse.getUniverses()) {
            if (universe.equals("default")) continue;
            this.msg("<aqua>" + universe + "<i>: " + Txt.implodeCommaAndDot(multiverse.getWorlds(universe), "<h>%s", "<i>, ", " <i>and ", "<i>."));
        }
        this.msg("<aqua>default<i>: for all other worlds.");
        this.msg("");
        this.msg("<i>Aspects using this multiverse:");
        this.msgAspects(multiverse.myAspects());
        this.msg("");
        this.msg("<i>Aspects NOT using this multiverse:");
        this.msgAspects(multiverse.otherAspects());
    }

    public void msgAspects(List<Aspect> aspects) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Aspect aspect : aspects) {
            ids.add(aspect.getId());
        }
        if (ids.size() == 0) {
            this.msg("<i>*none*");
        } else {
            this.msg(Txt.implodeCommaAndDot(ids, "<h>%s", "<i>, ", " <i>and ", "<i>."));
        }
    }
}

