/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.collections;

import com.massivecraft.massivecore.collections.BackstringSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class BackstringEnumSet<T extends Enum<?>>
extends BackstringSet<T> {
    private Class<T> clazz;
    private Map<String, T> name2enum = new LinkedHashMap<String, T>();

    private void init(Class<T> clazz) {
        this.clazz = clazz;
        for (Enum t : (Enum[])this.clazz.getEnumConstants()) {
            this.name2enum.put(t.name(), t);
        }
    }

    public BackstringEnumSet(Class<T> clazz) {
        this.init(clazz);
    }

    public BackstringEnumSet(Class<T> clazz, Collection<?> c) {
        super(c);
        this.init(clazz);
    }

    public BackstringEnumSet(Class<T> clazz, Object ... objects) {
        super(objects);
        this.init(clazz);
    }

    @Override
    public T convertFromString(String string) {
        return (T)((Enum)this.name2enum.get(string));
    }

    @Override
    public String convertToString(Object t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Enum) {
            Enum e = (Enum)t;
            return e.name();
        }
        return t.toString();
    }
}

