/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.collections;

import com.massivecraft.massivecore.collections.BackstringSet;
import java.util.Iterator;

public class BackstringIterator<E>
implements Iterator<E> {
    private final Iterator<String> iterator;
    private final BackstringSet<E> set;
    private String next = null;

    public BackstringIterator(Iterator<String> iterator, BackstringSet<E> set) {
        this.iterator = iterator;
        this.set = set;
        this.prepareNext();
    }

    private void prepareNext() {
        String perhaps = null;
        while (this.iterator.hasNext()) {
            perhaps = this.iterator.next();
            if (this.set.convertFromString(perhaps) == null) continue;
            this.next = perhaps;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        String current = this.next;
        this.prepareNext();
        if (current == null) {
            return null;
        }
        return this.set.convertFromString(current);
    }

    public String peek() {
        return this.next;
    }
}

