/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.fetcher;

import com.massivecraft.massivecore.fetcher.FetcherById;
import com.massivecraft.massivecore.fetcher.FetcherByName;
import com.massivecraft.massivecore.fetcher.IdAndName;
import com.massivecraft.massivecore.util.MUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Fetcher
implements Callable<Set<IdAndName>> {
    public static final ExecutorService ES = Executors.newFixedThreadPool(100);
    private final Collection<Object> objects;

    public Fetcher(Collection<Object> objects) {
        this.objects = objects;
    }

    @Override
    public Set<IdAndName> call() throws Exception {
        return Fetcher.fetch(this.objects);
    }

    public static Set<IdAndName> fetch(Collection<? extends Object> objects) throws Exception {
        final TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        final HashSet<UUID> ids = new HashSet<UUID>();
        for (Object object : objects) {
            if (object instanceof UUID) {
                UUID id = (UUID)object;
                ids.add(id);
                continue;
            }
            if (!(object instanceof String)) continue;
            String string = (String)object;
            if (MUtil.isValidPlayerName(string)) {
                names.add(string);
                continue;
            }
            if (!MUtil.isValidUUID(string)) continue;
            ids.add(UUID.fromString(string));
        }
        Callable<Set<IdAndName>> taskName = new Callable<Set<IdAndName>>(){

            @Override
            public Set<IdAndName> call() throws Exception {
                return new HashSet<IdAndName>(new FetcherByName(names).call().values());
            }
        };
        Callable<Set<IdAndName>> callable = new Callable<Set<IdAndName>>(){

            @Override
            public Set<IdAndName> call() throws Exception {
                return new HashSet<IdAndName>(new FetcherById(ids).call().values());
            }
        };
        ArrayList<Callable<Set<IdAndName>>> tasks = new ArrayList<Callable<Set<IdAndName>>>();
        tasks.add(taskName);
        tasks.add(callable);
        List futures = ES.invokeAll(tasks);
        HashSet<IdAndName> ret = new HashSet<IdAndName>();
        for (Future future : futures) {
            Set set = (Set)future.get();
            ret.addAll(set);
        }
        return ret;
    }
}

