/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.fetcher;

import com.massivecraft.massivecore.fetcher.FetcherByIdSingle;
import com.massivecraft.massivecore.fetcher.IdAndName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FetcherById
implements Callable<Map<Object, IdAndName>> {
    public static final ExecutorService ES = Executors.newFixedThreadPool(100);
    private final Collection<UUID> ids;

    public FetcherById(Collection<UUID> ids) {
        this.ids = ids;
    }

    @Override
    public Map<Object, IdAndName> call() throws Exception {
        return FetcherById.fetch(this.ids);
    }

    public static Map<Object, IdAndName> fetch(Collection<UUID> ids) throws Exception {
        ArrayList<FetcherByIdSingle> tasks = new ArrayList<FetcherByIdSingle>();
        for (UUID id : ids) {
            tasks.add(new FetcherByIdSingle(Arrays.asList(id)));
        }
        List futures = ES.invokeAll(tasks);
        HashMap<Object, IdAndName> ret = new HashMap<Object, IdAndName>();
        for (Future future : futures) {
            Map map = (Map)future.get();
            ret.putAll(map);
        }
        return ret;
    }
}

