/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.fetcher;

import com.massivecraft.massivecore.fetcher.IdAndName;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class FetcherByIdSingle
implements Callable<Map<UUID, IdAndName>> {
    public static final String PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";
    public static final String KEY_NAME = "name";
    public static final String KEY_CAUSE = "cause";
    public static final String KEY_ERROR_MESSAGE = "errorMessage";
    private final Collection<UUID> ids;

    public FetcherByIdSingle(Collection<UUID> ids) {
        this.ids = ids;
    }

    @Override
    public Map<UUID, IdAndName> call() throws Exception {
        return FetcherByIdSingle.fetch(this.ids);
    }

    public static Map<UUID, IdAndName> fetch(Collection<UUID> ids) throws Exception {
        HashMap<UUID, IdAndName> ret = new HashMap<UUID, IdAndName>();
        JSONParser jsonParser = new JSONParser();
        for (UUID id : ids) {
            HttpURLConnection connection = FetcherByIdSingle.createConnection(id);
            InputStream inputStream = connection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            JSONObject response = (JSONObject)jsonParser.parse((Reader)inputStreamReader);
            inputStreamReader.close();
            inputStream.close();
            connection.disconnect();
            String name = (String)response.get((Object)KEY_NAME);
            String cause = (String)response.get((Object)KEY_CAUSE);
            if (cause != null && cause.length() > 0) {
                String errorMessage = (String)response.get((Object)KEY_ERROR_MESSAGE);
                throw new IllegalStateException(errorMessage);
            }
            ret.put(id, new IdAndName(id, name));
        }
        return ret;
    }

    private static HttpURLConnection createConnection(UUID id) throws Exception {
        URL url = new URL(PROFILE_URL + id.toString().replace("-", ""));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }
}

