/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.fetcher;

import com.massivecraft.massivecore.fetcher.FetcherByNameSingle;
import com.massivecraft.massivecore.fetcher.IdAndName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FetcherByName
implements Callable<Map<String, IdAndName>> {
    public static final ExecutorService ES = Executors.newFixedThreadPool(100);
    public static final int BATCH_SIZE = 100;
    private final Collection<String> names;

    public FetcherByName(Collection<String> names) {
        this.names = names;
    }

    @Override
    public Map<String, IdAndName> call() throws Exception {
        return FetcherByName.fetch(this.names);
    }

    public static Map<String, IdAndName> fetch(Collection<String> names) throws Exception {
        ArrayList<List<String>> batches = new ArrayList<List<String>>();
        names = new ArrayList<String>(names);
        while (names.size() > 0) {
            List<String> batch = FetcherByName.take(names, 100);
            batches.add(batch);
        }
        ArrayList<FetcherByNameSingle> tasks = new ArrayList<FetcherByNameSingle>();
        for (List list : batches) {
            tasks.add(new FetcherByNameSingle(list));
        }
        List futures = ES.invokeAll(tasks);
        TreeMap<String, IdAndName> treeMap = new TreeMap<String, IdAndName>(String.CASE_INSENSITIVE_ORDER);
        for (Future future : futures) {
            treeMap.putAll((Map)future.get());
        }
        return treeMap;
    }

    public static <T> List<T> take(Collection<T> coll, int count) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = coll.iterator();
        for (int i = 0; iter.hasNext() && i < count; ++i) {
            ret.add(iter.next());
            iter.remove();
        }
        return ret;
    }
}

