/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.fetcher;

import com.massivecraft.massivecore.fetcher.IdAndName;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class FetcherByNameSingle
implements Callable<Map<String, IdAndName>> {
    public static final int PROFILES_PER_REQUEST = 100;
    public static final String PROFILE_URL = "https://api.mojang.com/profiles/minecraft";
    public static final String KEY_ID = "id";
    public static final String KEY_NAME = "name";
    private final Collection<String> names;
    private final boolean rateLimiting;

    public FetcherByNameSingle(Collection<String> names) {
        this(names, true);
    }

    public FetcherByNameSingle(Collection<String> names, boolean rateLimiting) {
        this.names = names;
        this.rateLimiting = rateLimiting;
    }

    @Override
    public Map<String, IdAndName> call() throws Exception {
        return FetcherByNameSingle.fetch(this.names, this.rateLimiting);
    }

    public static Map<String, IdAndName> fetch(Collection<String> namesCollection) throws Exception {
        return FetcherByNameSingle.fetch(namesCollection, true);
    }

    public static Map<String, IdAndName> fetch(Collection<String> namesCollection, boolean rateLimiting) throws Exception {
        ArrayList<String> names = new ArrayList<String>(namesCollection);
        TreeMap<String, IdAndName> ret = new TreeMap<String, IdAndName>(String.CASE_INSENSITIVE_ORDER);
        JSONParser jsonParser = new JSONParser();
        int requests = (int)Math.ceil((double)names.size() / 100.0);
        for (int i = 0; i < requests; ++i) {
            HttpURLConnection connection = FetcherByNameSingle.createConnection();
            String body = JSONArray.toJSONString(names.subList(i * 100, Math.min((i + 1) * 100, names.size())));
            FetcherByNameSingle.writeBody(connection, body);
            InputStream inputStream = connection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            JSONArray array = (JSONArray)jsonParser.parse((Reader)inputStreamReader);
            inputStreamReader.close();
            inputStream.close();
            connection.disconnect();
            for (Object profile : array) {
                JSONObject jsonProfile = (JSONObject)profile;
                String id = (String)jsonProfile.get((Object)KEY_ID);
                String name = (String)jsonProfile.get((Object)KEY_NAME);
                UUID uuid = FetcherByNameSingle.getUUID(id);
                ret.put(name, new IdAndName(uuid, name));
            }
            if (!rateLimiting || i == requests - 1) continue;
            Thread.sleep(100L);
        }
        for (String name : names) {
            IdAndName idAndName = (IdAndName)ret.get(name);
            if (idAndName == null) {
                idAndName = new IdAndName(null, name);
            }
            ret.put(name, idAndName);
        }
        return ret;
    }

    private static void writeBody(HttpURLConnection connection, String body) throws Exception {
        OutputStream stream = connection.getOutputStream();
        stream.write(body.getBytes());
        stream.flush();
        stream.close();
    }

    private static HttpURLConnection createConnection() throws Exception {
        URL url = new URL(PROFILE_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }

    private static UUID getUUID(String id) {
        return UUID.fromString(id.substring(0, 8) + "-" + id.substring(8, 12) + "-" + id.substring(12, 16) + "-" + id.substring(16, 20) + "-" + id.substring(20, 32));
    }

    public static byte[] toBytes(UUID uuid) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return byteBuffer.array();
    }

    public static UUID fromBytes(byte[] array) {
        if (array.length != 16) {
            throw new IllegalArgumentException("Illegal byte array length: " + array.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        long mostSignificant = byteBuffer.getLong();
        long leastSignificant = byteBuffer.getLong();
        return new UUID(mostSignificant, leastSignificant);
    }

    public static IdAndName get(String name) throws Exception {
        return FetcherByNameSingle.fetch(Arrays.asList(name)).get(name);
    }
}

