/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.integration;

import com.massivecraft.massivecore.MassivePlugin;
import com.massivecraft.massivecore.integration.Integration;
import com.massivecraft.massivecore.util.Txt;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class IntegrationGlue
implements Listener {
    protected MassivePlugin ourPlugin;
    protected Integration features;
    protected boolean active = false;

    public boolean isActive() {
        return this.active;
    }

    public IntegrationGlue(MassivePlugin ourPlugin, Integration features) {
        this.ourPlugin = ourPlugin;
        this.features = features;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.ourPlugin);
        this.tick();
    }

    public void tick() {
        String namelist = Txt.implodeCommaAndDot(this.features.getTargetPluginNames(), "<h>%s", "<i>, ", " <i>and ", "<i>.");
        if (IntegrationGlue.isPluginsEnabled(this.features.getTargetPluginNames())) {
            if (!this.active) {
                try {
                    this.features.activate();
                    this.active = true;
                    this.ourPlugin.log(Txt.parse("<g>Activated <i>integration with " + namelist));
                }
                catch (Exception e) {
                    this.ourPlugin.log(Txt.parse("<b>Failed to activate <i>integration with " + namelist));
                    e.printStackTrace();
                }
            }
        } else if (this.active) {
            try {
                this.active = false;
                this.features.deactivate();
                this.ourPlugin.log(Txt.parse("<g>Deactivated <i>integration with " + namelist));
            }
            catch (Exception e) {
                this.ourPlugin.log(Txt.parse("<b>Failed to deactivate <i>integration with " + namelist));
                e.printStackTrace();
            }
        }
    }

    public static boolean isPluginEnabled(String pluginName) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        if (plugin == null) {
            return false;
        }
        return plugin.isEnabled();
    }

    public static boolean isPluginsEnabled(Collection<String> pluginNames) {
        for (String pluginName : pluginNames) {
            if (IntegrationGlue.isPluginEnabled(pluginName)) continue;
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginDisable(PluginDisableEvent event) {
        this.tick();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginEnable(PluginEnableEvent event) {
        this.tick();
    }
}

