/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.mixin;

import com.massivecraft.massivecore.event.EventMassiveCorePlayerPSTeleport;
import com.massivecraft.massivecore.mixin.EngineTeleportMixinCause;
import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.mixin.TeleportMixinAbstract;
import com.massivecraft.massivecore.mixin.TeleporterException;
import com.massivecraft.massivecore.ps.PS;
import com.massivecraft.massivecore.teleport.PSGetter;
import com.massivecraft.massivecore.teleport.ScheduledTeleport;
import com.massivecraft.massivecore.util.IdUtil;
import com.massivecraft.massivecore.util.Txt;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class TeleportMixinDefault
extends TeleportMixinAbstract {
    private static TeleportMixinDefault i = new TeleportMixinDefault();

    public static TeleportMixinDefault get() {
        return i;
    }

    public static void teleportPlayer(Player player, PS ps) throws TeleporterException {
        ps = ps.getEntity(true);
        ps = PS.valueOf(player.getLocation()).with(ps);
        Location location = null;
        try {
            location = ps.asBukkitLocation();
        }
        catch (Exception e) {
            throw new TeleporterException(Txt.parse("<b>Could not calculate the location: %s", e.getMessage()));
        }
        player.eject();
        Entity vehicle = player.getVehicle();
        if (vehicle != null) {
            vehicle.eject();
        }
        EngineTeleportMixinCause.get().setMixinCausedTeleportIncoming(true);
        player.teleport(location);
        EngineTeleportMixinCause.get().setMixinCausedTeleportIncoming(false);
        Vector velocity = null;
        try {
            velocity = ps.asBukkitVelocity();
        }
        catch (Exception e) {
            return;
        }
        player.setVelocity(velocity);
    }

    @Override
    public void teleport(Object teleporteeObject, PSGetter toGetter, String desc, int delaySeconds) throws TeleporterException {
        String teleporteeId = IdUtil.getId(teleporteeObject);
        if (!IdUtil.isPlayerId(teleporteeId)) {
            throw new TeleporterException(Txt.parse("<white>%s <b>is not a player.", Mixin.getDisplayName(teleporteeId, IdUtil.getConsole())));
        }
        if (delaySeconds > 0) {
            if (desc != null) {
                Mixin.msgOne((Object)teleporteeId, "<i>Teleporting to <h>" + desc + " <i>in <h>" + delaySeconds + "s <i>unless you move.");
            } else {
                Mixin.msgOne((Object)teleporteeId, "<i>Teleporting in <h>" + delaySeconds + "s <i>unless you move.");
            }
            new ScheduledTeleport(teleporteeId, toGetter, desc, delaySeconds).schedule();
        } else {
            Player teleportee;
            PS to = toGetter.getPS();
            EventMassiveCorePlayerPSTeleport event = new EventMassiveCorePlayerPSTeleport(teleporteeId, Mixin.getSenderPs(teleporteeId), to, desc);
            event.run();
            if (event.isCancelled()) {
                return;
            }
            if (event.getTo() == null) {
                return;
            }
            to = event.getTo();
            desc = event.getDesc();
            if (desc != null) {
                Mixin.msgOne((Object)teleporteeId, "<i>Teleporting to <h>" + desc + "<i>.");
            }
            if ((teleportee = IdUtil.getPlayer(teleporteeId)) != null) {
                TeleportMixinDefault.teleportPlayer(teleportee, to);
            } else {
                Mixin.setSenderPs(teleporteeId, to);
            }
        }
    }
}

