/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.money;

import com.massivecraft.massivecore.money.MoneyMixin;
import com.massivecraft.massivecore.util.MUtil;
import java.util.Collection;

public class Money {
    private static MoneyMixin mixin = null;

    public static MoneyMixin mixin() {
        return mixin;
    }

    public static void mixin(MoneyMixin mixin) {
        Money.mixin = mixin;
    }

    public static String accountId(Object account) {
        if (account == null) {
            return null;
        }
        String ret = MUtil.extract(String.class, "accountId", account);
        if (ret == null) {
            throw new IllegalArgumentException("extraction of accountId from object failed");
        }
        return ret;
    }

    public static boolean enabled() {
        if (mixin == null) {
            return false;
        }
        return mixin.enabled();
    }

    public static boolean disabled() {
        return !Money.enabled();
    }

    public static String format(double amount) {
        if (Money.disabled()) {
            return String.valueOf(amount);
        }
        return mixin.format(amount);
    }

    public static String format(double amount, boolean includeUnit) {
        if (Money.disabled()) {
            return String.valueOf(amount) + (includeUnit ? "$" : "");
        }
        return mixin.format(amount, includeUnit);
    }

    public static String singular() {
        if (Money.disabled()) {
            return "singular";
        }
        return mixin.singular();
    }

    public static String plural() {
        if (Money.disabled()) {
            return "plural";
        }
        return mixin.plural();
    }

    public static int fractionalDigits() {
        if (Money.disabled()) {
            return 0;
        }
        return mixin.fractionalDigits();
    }

    public static double prepare(double amount) {
        if (Money.disabled()) {
            return amount;
        }
        return mixin.prepare(amount);
    }

    public static boolean exists(Object account) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.exists(Money.accountId(account));
    }

    public static boolean create(Object account) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.create(Money.accountId(account));
    }

    public static double get(Object account) {
        if (Money.disabled()) {
            return 0.0;
        }
        return mixin.get(Money.accountId(account));
    }

    public static boolean has(Object account, double amount) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.has(Money.accountId(account), amount);
    }

    public static boolean move(Object from, Object to, Object by, double amount, Collection<String> categories, String message) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.move(Money.accountId(from), Money.accountId(to), Money.accountId(by), amount, categories, message);
    }

    public static boolean move(Object from, Object to, Object by, double amount, String category, String message) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.move(Money.accountId(from), Money.accountId(to), Money.accountId(by), amount, category, message);
    }

    public static boolean move(Object from, Object to, Object by, double amount, Collection<String> categories) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.move(Money.accountId(from), Money.accountId(to), Money.accountId(by), amount, categories);
    }

    public static boolean move(Object from, Object to, Object by, double amount, String category) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.move(Money.accountId(from), Money.accountId(to), Money.accountId(by), amount, category);
    }

    public static boolean move(Object from, Object to, Object by, double amount) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.move(Money.accountId(from), Money.accountId(to), Money.accountId(by), amount);
    }

    public static boolean spawn(Object to, Object by, double amount, Collection<String> categories, String message) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.spawn(Money.accountId(to), Money.accountId(by), amount, categories, message);
    }

    public static boolean spawn(Object to, Object by, double amount, String category, String message) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.spawn(Money.accountId(to), Money.accountId(by), amount, category, message);
    }

    public static boolean spawn(Object to, Object by, double amount, Collection<String> categories) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.spawn(Money.accountId(to), Money.accountId(by), amount, categories);
    }

    public static boolean spawn(Object to, Object by, double amount, String category) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.spawn(Money.accountId(to), Money.accountId(by), amount, category);
    }

    public static boolean spawn(Object to, Object by, double amount) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.spawn(Money.accountId(to), Money.accountId(by), amount);
    }

    public static boolean despawn(Object from, Object by, double amount, Collection<String> categories, String message) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.despawn(Money.accountId(from), Money.accountId(by), amount, categories, message);
    }

    public static boolean despawn(Object from, Object by, double amount, String category, String message) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.despawn(Money.accountId(from), Money.accountId(by), amount, category, message);
    }

    public static boolean despawn(Object from, Object by, double amount, Collection<String> categories) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.despawn(Money.accountId(from), Money.accountId(by), amount, categories);
    }

    public static boolean despawn(Object from, Object by, double amount, String category) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.despawn(Money.accountId(from), Money.accountId(by), amount, category);
    }

    public static boolean despawn(Object from, Object by, double amount) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.despawn(Money.accountId(from), Money.accountId(by), amount);
    }

    public static boolean set(Object account, Object by, double amount, Collection<String> categories, String message) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.set(Money.accountId(account), Money.accountId(by), amount, categories, message);
    }

    public static boolean set(Object account, Object by, double amount, String category, String message) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.set(Money.accountId(account), Money.accountId(by), amount, category, message);
    }

    public static boolean set(Object account, Object by, double amount, Collection<String> categories) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.set(Money.accountId(account), Money.accountId(by), amount, categories);
    }

    public static boolean set(Object account, Object by, double amount, String category) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.set(Money.accountId(account), Money.accountId(by), amount, category);
    }

    public static boolean set(Object account, Object by, double amount) {
        if (Money.disabled()) {
            return false;
        }
        return mixin.set(Money.accountId(account), Money.accountId(by), amount);
    }
}

