/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.money;

import com.massivecraft.massivecore.money.MoneyMixin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class MoneyMixinAbstract
implements MoneyMixin {
    @Override
    public String format(double amount) {
        return this.format(amount, true);
    }

    @Override
    public double prepare(double amount) {
        int fractionalDigits = this.fractionalDigits();
        if (fractionalDigits < 0) {
            return amount;
        }
        if (fractionalDigits == 0) {
            return Math.ceil(amount);
        }
        int factor = (int)Math.round(Math.pow(10.0, fractionalDigits));
        amount *= (double)factor;
        amount = Math.ceil(amount);
        return amount /= (double)factor;
    }

    @Override
    public boolean move(String fromId, String toId, String byId, double amount, String category, String message) {
        return this.move(fromId, toId, byId, amount, category == null ? null : Arrays.asList(category), message);
    }

    @Override
    public boolean move(String fromId, String toId, String byId, double amount, Collection<String> categories) {
        return this.move(fromId, toId, byId, amount, categories, null);
    }

    @Override
    public boolean move(String fromId, String toId, String byId, double amount, String category) {
        return this.move(fromId, toId, byId, amount, category == null ? null : Arrays.asList(category), null);
    }

    @Override
    public boolean move(String fromId, String toId, String byId, double amount) {
        return this.move(fromId, toId, byId, amount, new ArrayList<String>(), null);
    }

    @Override
    public boolean spawn(String toId, String byId, double amount, Collection<String> categories, String message) {
        return this.move(null, toId, byId, amount, categories, message);
    }

    @Override
    public boolean spawn(String toId, String byId, double amount, String category, String message) {
        return this.move(null, toId, byId, amount, category, message);
    }

    @Override
    public boolean spawn(String toId, String byId, double amount, Collection<String> categories) {
        return this.move(null, toId, byId, amount, categories);
    }

    @Override
    public boolean spawn(String toId, String byId, double amount, String category) {
        return this.move(null, toId, byId, amount, category);
    }

    @Override
    public boolean spawn(String toId, String byId, double amount) {
        return this.move(null, toId, byId, amount);
    }

    @Override
    public boolean despawn(String fromId, String byId, double amount, Collection<String> categories, String message) {
        return this.move(fromId, null, byId, amount, categories, message);
    }

    @Override
    public boolean despawn(String fromId, String byId, double amount, String category, String message) {
        return this.move(fromId, null, byId, amount, category, message);
    }

    @Override
    public boolean despawn(String fromId, String byId, double amount, Collection<String> categories) {
        return this.move(fromId, null, byId, amount, categories);
    }

    @Override
    public boolean despawn(String fromId, String byId, double amount, String category) {
        return this.move(fromId, null, byId, amount, category);
    }

    @Override
    public boolean despawn(String fromId, String byId, double amount) {
        return this.move(fromId, null, byId, amount);
    }

    @Override
    public boolean set(String accountId, String byId, double amount, Collection<String> categories, String message) {
        return this.move(null, accountId, byId, amount - this.get(accountId), categories, message);
    }

    @Override
    public boolean set(String accountId, String byId, double amount, String category, String message) {
        return this.move(null, accountId, byId, amount - this.get(accountId), category, message);
    }

    @Override
    public boolean set(String accountId, String byId, double amount, Collection<String> categories) {
        return this.move(null, accountId, byId, amount - this.get(accountId), categories);
    }

    @Override
    public boolean set(String accountId, String byId, double amount, String category) {
        return this.move(null, accountId, byId, amount - this.get(accountId), category);
    }

    @Override
    public boolean set(String accountId, String byId, double amount) {
        return this.move(null, accountId, byId, amount - this.get(accountId));
    }
}

