/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.money;

import com.massivecraft.massivecore.money.Money;
import com.massivecraft.massivecore.money.MoneyMixinAbstract;
import com.massivecraft.massivecore.util.MUtil;
import java.util.Collection;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;

public class MoneyMixinVault
extends MoneyMixinAbstract {
    private static final MoneyMixinVault i = new MoneyMixinVault();
    private Economy economy = null;

    public static MoneyMixinVault get() {
        return i;
    }

    public void activate() {
        if (Money.mixin() != null) {
            return;
        }
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return;
        }
        this.economy = (Economy)rsp.getProvider();
        Money.mixin(this);
    }

    public void deactivate() {
        Money.mixin(null);
    }

    @Override
    public boolean enabled() {
        return this.economy.isEnabled();
    }

    @Override
    public String format(double amount, boolean includeUnit) {
        if (includeUnit) {
            return this.economy.format(amount);
        }
        int fractionalDigits = this.fractionalDigits();
        if (fractionalDigits < 0) {
            return String.valueOf(amount);
        }
        if (fractionalDigits == 0) {
            return String.valueOf((int)Math.round(amount));
        }
        return String.format("%." + fractionalDigits + "f", amount);
    }

    @Override
    public String singular() {
        return this.economy.currencyNameSingular();
    }

    @Override
    public String plural() {
        return this.economy.currencyNamePlural();
    }

    @Override
    public int fractionalDigits() {
        return this.economy.fractionalDigits();
    }

    @Override
    public boolean exists(String accountId) {
        return this.economy.hasAccount(accountId);
    }

    @Override
    public boolean create(String accountId) {
        return this.ensureExists(accountId);
    }

    @Override
    public double get(String accountId) {
        this.ensureExists(accountId);
        return this.economy.getBalance(accountId);
    }

    @Override
    public boolean has(String accountId, double amount) {
        this.ensureExists(accountId);
        return this.economy.has(accountId, amount);
    }

    @Override
    public boolean move(String fromId, String toId, String byId, double amount, Collection<String> categories, String message) {
        if (amount < 0.0) {
            amount *= -1.0;
            String temp = fromId;
            fromId = toId;
            toId = temp;
        }
        if (fromId != null) {
            this.ensureExists(fromId);
        }
        if (toId != null) {
            this.ensureExists(toId);
        }
        if (fromId != null && !this.economy.withdrawPlayer(fromId, amount).transactionSuccess()) {
            return false;
        }
        if (toId != null && !this.economy.depositPlayer(toId, amount).transactionSuccess()) {
            if (fromId != null) {
                this.economy.depositPlayer(fromId, amount);
            }
            return false;
        }
        return true;
    }

    public boolean ensureExists(String accountId) {
        if (this.economy.hasAccount(accountId)) {
            return true;
        }
        if (!this.economy.createPlayerAccount(accountId)) {
            return false;
        }
        if (MUtil.isValidPlayerName(accountId)) {
            return true;
        }
        double balance = this.economy.getBalance(accountId);
        this.economy.withdrawPlayer(accountId, balance);
        return true;
    }
}

