/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.pager;

import com.massivecraft.massivecore.pager.Pager;
import com.massivecraft.massivecore.pager.Stringifier;
import com.massivecraft.massivecore.util.Txt;
import java.util.ArrayList;
import java.util.List;

public abstract class PagerAbstract<T>
implements Pager<T> {
    @Override
    public int size() {
        return (int)Math.ceil((double)this.getItems().size() / (double)this.getItemsPerPage());
    }

    @Override
    public boolean isValid(int number) {
        if (this.isEmpty()) {
            return false;
        }
        if (number < 1) {
            return false;
        }
        return number <= this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.getItems().isEmpty();
    }

    @Override
    public List<T> get(int number) {
        if (!this.isValid(number)) {
            return null;
        }
        ArrayList ret = new ArrayList();
        ArrayList items = null;
        items = this.getItems() instanceof List ? (ArrayList)this.getItems() : new ArrayList(this.getItems());
        int index = number - 1;
        int from = index * this.getItemsPerPage();
        int to = from + this.getItemsPerPage();
        if (to > items.size()) {
            to = items.size();
        }
        ret.addAll(items.subList(from, to));
        return ret;
    }

    @Override
    public String getMessageEmpty() {
        return Txt.parse("<i>Sorry, no pages available.");
    }

    @Override
    public String getMessageInvalid() {
        if (this.size() == 0) {
            return this.getMessageEmpty();
        }
        if (this.size() == 1) {
            return Txt.parse("<b>Invalid, there is only one page.", this.size());
        }
        return Txt.parse("<b>Invalid, page must be between 1 and %d.", this.size());
    }

    @Override
    public List<String> getPageTxt(int number, String title, Stringifier<T> stringifier) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Txt.titleize(title + Txt.parse("<a>") + " " + number + "/" + this.size()));
        if (this.isEmpty()) {
            ret.add(this.getMessageEmpty());
            return ret;
        }
        List<T> pageItems = this.get(number);
        if (pageItems == null) {
            ret.add(this.getMessageInvalid());
            return ret;
        }
        for (T pageItem : pageItems) {
            if (stringifier != null) {
                ret.add(stringifier.toString(pageItem));
                continue;
            }
            ret.add(pageItem.toString());
        }
        return ret;
    }
}

