/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.ps;

import com.massivecraft.massivecore.Aspect;
import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.Multiverse;
import com.massivecraft.massivecore.ps.PSBuilder;
import com.massivecraft.massivecore.ps.PSFormat;
import com.massivecraft.massivecore.ps.PSFormatFormal;
import com.massivecraft.massivecore.util.MUtil;
import com.massivecraft.massivecore.xlib.gson.JsonElement;
import com.massivecraft.massivecore.xlib.gson.JsonObject;
import com.massivecraft.massivecore.xlib.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public final class PS
implements Cloneable,
Serializable,
Comparable<PS> {
    private static final transient long serialVersionUID = 1L;
    public static final transient float DEFAULT_BUKKIT_PITCH = 0.0f;
    public static final transient float DEFAULT_BUKKIT_YAW = 0.0f;
    public static final transient String NAME_SERIALIZED_WORLD = "w";
    public static final transient String NAME_SERIALIZED_BLOCKX = "bx";
    public static final transient String NAME_SERIALIZED_BLOCKY = "by";
    public static final transient String NAME_SERIALIZED_BLOCKZ = "bz";
    public static final transient String NAME_SERIALIZED_LOCATIONX = "lx";
    public static final transient String NAME_SERIALIZED_LOCATIONY = "ly";
    public static final transient String NAME_SERIALIZED_LOCATIONZ = "lz";
    public static final transient String NAME_SERIALIZED_CHUNKX = "cx";
    public static final transient String NAME_SERIALIZED_CHUNKZ = "cz";
    public static final transient String NAME_SERIALIZED_PITCH = "p";
    public static final transient String NAME_SERIALIZED_YAW = "y";
    public static final transient String NAME_SERIALIZED_VELOCITYX = "vx";
    public static final transient String NAME_SERIALIZED_VELOCITYY = "vy";
    public static final transient String NAME_SERIALIZED_VELOCITYZ = "vz";
    public static final transient String NAME_FULL_WORLD = "world";
    public static final transient String NAME_FULL_BLOCKX = "blockX";
    public static final transient String NAME_FULL_BLOCKY = "blockY";
    public static final transient String NAME_FULL_BLOCKZ = "blockZ";
    public static final transient String NAME_FULL_LOCATIONX = "locationX";
    public static final transient String NAME_FULL_LOCATIONY = "locationY";
    public static final transient String NAME_FULL_LOCATIONZ = "locationZ";
    public static final transient String NAME_FULL_CHUNKX = "chunkX";
    public static final transient String NAME_FULL_CHUNKZ = "chunkZ";
    public static final transient String NAME_FULL_PITCH = "pitch";
    public static final transient String NAME_FULL_YAW = "yaw";
    public static final transient String NAME_FULL_VELOCITYX = "velocityX";
    public static final transient String NAME_FULL_VELOCITYY = "velocityY";
    public static final transient String NAME_FULL_VELOCITYZ = "velocityZ";
    public static final transient String NAME_VERBOOSE_WORLD = "World";
    public static final transient String NAME_VERBOOSE_BLOCKX = "Block X";
    public static final transient String NAME_VERBOOSE_BLOCKY = "Block Y";
    public static final transient String NAME_VERBOOSE_BLOCKZ = "Block Z";
    public static final transient String NAME_VERBOOSE_LOCATIONX = "Location X";
    public static final transient String NAME_VERBOOSE_LOCATIONY = "Location Y";
    public static final transient String NAME_VERBOOSE_LOCATIONZ = "Location Z";
    public static final transient String NAME_VERBOOSE_CHUNKX = "Chunk X";
    public static final transient String NAME_VERBOOSE_CHUNKZ = "Chunk Z";
    public static final transient String NAME_VERBOOSE_PITCH = "Pitch";
    public static final transient String NAME_VERBOOSE_YAW = "Yaw";
    public static final transient String NAME_VERBOOSE_VELOCITYX = "Velocity X";
    public static final transient String NAME_VERBOOSE_VELOCITYY = "Velocity Y";
    public static final transient String NAME_VERBOOSE_VELOCITYZ = "Velocity Z";
    public static final transient String SPACE_WASNT_SET = " wasn't set";
    public static final transient PS NULL = new PS(null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    @SerializedName(value="w")
    private final String world;
    @SerializedName(value="bx")
    private final Integer blockX;
    @SerializedName(value="by")
    private final Integer blockY;
    @SerializedName(value="bz")
    private final Integer blockZ;
    @SerializedName(value="lx")
    private final Double locationX;
    @SerializedName(value="ly")
    private final Double locationY;
    @SerializedName(value="lz")
    private final Double locationZ;
    @SerializedName(value="cx")
    private final Integer chunkX;
    @SerializedName(value="cz")
    private final Integer chunkZ;
    @SerializedName(value="p")
    private final Float pitch;
    @SerializedName(value="y")
    private final Float yaw;
    @SerializedName(value="vx")
    private final Double velocityX;
    @SerializedName(value="vy")
    private final Double velocityY;
    @SerializedName(value="vz")
    private final Double velocityZ;
    private volatile transient boolean hashed = false;
    private volatile transient int hashcode = 0;

    public String getWorld() {
        return this.world;
    }

    public Integer getBlockX() {
        return this.blockX;
    }

    public Integer getBlockY() {
        return this.blockY;
    }

    public Integer getBlockZ() {
        return this.blockZ;
    }

    public Double getLocationX() {
        return this.locationX;
    }

    public Double getLocationY() {
        return this.locationY;
    }

    public Double getLocationZ() {
        return this.locationZ;
    }

    public Integer getChunkX() {
        return this.chunkX;
    }

    public Integer getChunkZ() {
        return this.chunkZ;
    }

    public Float getPitch() {
        return this.pitch;
    }

    public Float getYaw() {
        return this.yaw;
    }

    public Double getVelocityX() {
        return this.velocityX;
    }

    public Double getVelocityY() {
        return this.velocityY;
    }

    public Double getVelocityZ() {
        return this.velocityZ;
    }

    public PS withWorld(String world) {
        return new PS(world, this.blockX, this.blockY, this.blockZ, this.locationX, this.locationY, this.locationZ, this.chunkX, this.chunkZ, this.pitch, this.yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withBlockX(Integer blockX) {
        return new PS(this.world, blockX, this.blockY, this.blockZ, this.locationX, this.locationY, this.locationZ, this.chunkX, this.chunkZ, this.pitch, this.yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withBlockY(Integer blockY) {
        return new PS(this.world, this.blockX, blockY, this.blockZ, this.locationX, this.locationY, this.locationZ, this.chunkX, this.chunkZ, this.pitch, this.yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withBlockZ(Integer blockZ) {
        return new PS(this.world, this.blockX, this.blockY, blockZ, this.locationX, this.locationY, this.locationZ, this.chunkX, this.chunkZ, this.pitch, this.yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withLocationX(Double locationX) {
        return new PS(this.world, this.blockX, this.blockY, this.blockZ, locationX, this.locationY, this.locationZ, this.chunkX, this.chunkZ, this.pitch, this.yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withLocationY(Double locationY) {
        return new PS(this.world, this.blockX, this.blockY, this.blockZ, this.locationX, locationY, this.locationZ, this.chunkX, this.chunkZ, this.pitch, this.yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withLocationZ(Double locationZ) {
        return new PS(this.world, this.blockX, this.blockY, this.blockZ, this.locationX, this.locationY, locationZ, this.chunkX, this.chunkZ, this.pitch, this.yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withChunkX(Integer chunkX) {
        return new PS(this.world, this.blockX, this.blockY, this.blockZ, this.locationX, this.locationY, this.locationZ, chunkX, this.chunkZ, this.pitch, this.yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withChunkZ(Integer chunkZ) {
        return new PS(this.world, this.blockX, this.blockY, this.blockZ, this.locationX, this.locationY, this.locationZ, this.chunkX, chunkZ, this.pitch, this.yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withPitch(Float pitch) {
        return new PS(this.world, this.blockX, this.blockY, this.blockZ, this.locationX, this.locationY, this.locationZ, this.chunkX, this.chunkZ, pitch, this.yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withYaw(Float yaw) {
        return new PS(this.world, this.blockX, this.blockY, this.blockZ, this.locationX, this.locationY, this.locationZ, this.chunkX, this.chunkZ, this.pitch, yaw, this.velocityX, this.velocityY, this.velocityZ);
    }

    public PS withVelocityX(Double velocityX) {
        return new PS(this.world, this.blockX, this.blockY, this.blockZ, this.locationX, this.locationY, this.locationZ, this.chunkX, this.chunkZ, this.pitch, this.yaw, velocityX, this.velocityY, this.velocityZ);
    }

    public PS withVelocityY(Double velocityY) {
        return new PS(this.world, this.blockX, this.blockY, this.blockZ, this.locationX, this.locationY, this.locationZ, this.chunkX, this.chunkZ, this.pitch, this.yaw, this.velocityX, velocityY, this.velocityZ);
    }

    public PS withVelocityZ(Double velocityZ) {
        return new PS(this.world, this.blockX, this.blockY, this.blockZ, this.locationX, this.locationY, this.locationZ, this.chunkX, this.chunkZ, this.pitch, this.yaw, this.velocityX, this.velocityY, velocityZ);
    }

    public PS with(PS ps) {
        PSBuilder builder = this.builder();
        if (ps.getWorld() != null) {
            builder.world(ps.getWorld());
        }
        if (ps.getBlockX() != null) {
            builder.blockX(ps.getBlockX());
        }
        if (ps.getBlockY() != null) {
            builder.blockY(ps.getBlockY());
        }
        if (ps.getBlockZ() != null) {
            builder.blockZ(ps.getBlockZ());
        }
        if (ps.getLocationX() != null) {
            builder.locationX(ps.getLocationX());
        }
        if (ps.getLocationY() != null) {
            builder.locationY(ps.getLocationY());
        }
        if (ps.getLocationZ() != null) {
            builder.locationZ(ps.getLocationZ());
        }
        if (ps.getChunkX() != null) {
            builder.chunkX(ps.getChunkX());
        }
        if (ps.getChunkZ() != null) {
            builder.chunkZ(ps.getChunkZ());
        }
        if (ps.getPitch() != null) {
            builder.pitch(ps.getPitch());
        }
        if (ps.getYaw() != null) {
            builder.yaw(ps.getYaw());
        }
        if (ps.getVelocityX() != null) {
            builder.velocityX(ps.getVelocityX());
        }
        if (ps.getVelocityY() != null) {
            builder.velocityY(ps.getVelocityY());
        }
        if (ps.getVelocityZ() != null) {
            builder.velocityZ(ps.getVelocityZ());
        }
        return builder.build();
    }

    public PS plusChunkCoords(int chunkX, int chunkZ) {
        PSBuilder builder = this.builder();
        if (builder.chunkX() != null) {
            builder.chunkX(builder.chunkX() + chunkX);
        }
        if (builder.chunkZ() != null) {
            builder.chunkZ(builder.chunkZ() + chunkZ);
        }
        return builder.build();
    }

    public boolean isWorldLoadedOnThisServer() {
        if (this.world == null) {
            return true;
        }
        return MUtil.getLoadedWorldNames().contains(this.world);
    }

    private PS(String worldName, Integer blockX, Integer blockY, Integer blockZ, Double locationX, Double locationY, Double locationZ, Integer chunkX, Integer chunkZ, Float pitch, Float yaw, Double velocityX, Double velocityY, Double velocityZ) {
        this.world = worldName;
        this.blockX = blockX;
        this.blockY = blockY;
        this.blockZ = blockZ;
        this.locationX = PS.throwIfStrange(locationX, NAME_VERBOOSE_LOCATIONX);
        this.locationY = PS.throwIfStrange(locationY, NAME_VERBOOSE_LOCATIONY);
        this.locationZ = PS.throwIfStrange(locationZ, NAME_VERBOOSE_LOCATIONZ);
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.pitch = PS.throwIfStrange(pitch, NAME_VERBOOSE_PITCH);
        this.yaw = PS.throwIfStrange(yaw, NAME_VERBOOSE_YAW);
        this.velocityX = PS.throwIfStrange(velocityX, NAME_VERBOOSE_VELOCITYX);
        this.velocityY = PS.throwIfStrange(velocityY, NAME_VERBOOSE_VELOCITYY);
        this.velocityZ = PS.throwIfStrange(velocityZ, NAME_VERBOOSE_VELOCITYZ);
    }

    public static Double throwIfStrange(Double d, String name) {
        if (d == null) {
            return null;
        }
        if (d.isInfinite()) {
            throw new IllegalArgumentException(name + " should not be Infinite!");
        }
        if (d.isNaN()) {
            throw new IllegalArgumentException(name + " should not be NaN!");
        }
        return d;
    }

    public static Float throwIfStrange(Float f, String name) {
        if (f == null) {
            return null;
        }
        if (f.isInfinite()) {
            throw new IllegalArgumentException(name + " should not be Infinite!");
        }
        if (f.isNaN()) {
            throw new IllegalArgumentException(name + " should not be NaN!");
        }
        return f;
    }

    public PSBuilder builder() {
        return new PSBuilder(this);
    }

    public static PS valueOf(String world, Integer blockX, Integer blockY, Integer blockZ, Double locationX, Double locationY, Double locationZ, Integer chunkX, Integer chunkZ, Float pitch, Float yaw, Double velocityX, Double velocityY, Double velocityZ) {
        return new PS(world, blockX, blockY, blockZ, locationX, locationY, locationZ, chunkX, chunkZ, pitch, yaw, velocityX, velocityY, velocityZ);
    }

    public static PS valueOf(Location location) {
        if (location == null) {
            return null;
        }
        String world = PS.calcWorldName(location.getWorld());
        Double locationX = location.getX();
        Double locationY = location.getY();
        Double locationZ = location.getZ();
        Float pitch = Float.valueOf(location.getPitch());
        Float yaw = Float.valueOf(location.getYaw());
        return PS.valueOf(world, null, null, null, locationX, locationY, locationZ, null, null, pitch, yaw, null, null, null);
    }

    public static PS valueOf(Vector velocity) {
        if (velocity == null) {
            return null;
        }
        Double velocityX = velocity.getX();
        Double velocityY = velocity.getY();
        Double velocityZ = velocity.getZ();
        return PS.valueOf(null, null, null, null, null, null, null, null, null, null, null, velocityX, velocityY, velocityZ);
    }

    public static PS valueOf(Entity entity) {
        if (entity == null) {
            return null;
        }
        Location location = entity.getLocation();
        String world = PS.calcWorldName(location.getWorld());
        Double locationX = location.getX();
        Double locationY = location.getY();
        Double locationZ = location.getZ();
        Float pitch = Float.valueOf(location.getPitch());
        Float yaw = Float.valueOf(location.getYaw());
        Vector velocity = entity.getVelocity();
        Double velocityX = velocity.getX();
        Double velocityY = PS.trimEntityVelocityY(velocity.getY());
        Double velocityZ = velocity.getZ();
        return PS.valueOf(world, null, null, null, locationX, locationY, locationZ, null, null, pitch, yaw, velocityX, velocityY, velocityZ);
    }

    public static PS valueOf(Block block) {
        if (block == null) {
            return null;
        }
        String world = PS.calcWorldName(block.getWorld());
        Integer blockX = block.getX();
        Integer blockY = block.getY();
        Integer blockZ = block.getZ();
        return PS.valueOf(world, blockX, blockY, blockZ, null, null, null, null, null, null, null, null, null, null);
    }

    public static PS valueOf(String world, int chunkX, int chunkZ) {
        return PS.valueOf(world, null, null, null, null, null, null, chunkX, chunkZ, null, null, null, null, null);
    }

    public static PS valueOf(Chunk chunk) {
        if (chunk == null) {
            return null;
        }
        String world = PS.calcWorldName(chunk.getWorld());
        Integer chunkX = chunk.getX();
        Integer chunkZ = chunk.getZ();
        return PS.valueOf(world, chunkX, chunkZ);
    }

    public static PS valueOf(int chunkX, int chunkZ) {
        return PS.valueOf(null, null, null, null, null, null, null, chunkX, chunkZ, null, null, null, null, null);
    }

    public static PS valueOf(JsonElement jsonElement) {
        if (jsonElement == null) {
            return null;
        }
        if (jsonElement.isJsonNull()) {
            return null;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        PSBuilder builder = new PSBuilder();
        if (jsonObject.has(NAME_FULL_WORLD) && jsonObject.has(NAME_FULL_YAW)) {
            for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                String key = entry.getKey();
                JsonElement value = entry.getValue();
                if (key.equals(NAME_FULL_WORLD)) {
                    builder.world(value.getAsString());
                    continue;
                }
                if (key.equals("x")) {
                    builder.locationX(value.getAsDouble());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_YAW)) {
                    builder.locationY(value.getAsDouble());
                    continue;
                }
                if (key.equals("z")) {
                    builder.locationZ(value.getAsDouble());
                    continue;
                }
                if (key.equals(NAME_FULL_PITCH)) {
                    builder.pitch(Float.valueOf(value.getAsFloat()));
                    continue;
                }
                if (!key.equals(NAME_FULL_YAW)) continue;
                builder.yaw(Float.valueOf(value.getAsFloat()));
            }
        } else {
            for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                String key = entry.getKey();
                JsonElement value = entry.getValue();
                if (key.equals(NAME_SERIALIZED_WORLD)) {
                    builder.world(value.getAsString());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_BLOCKX)) {
                    builder.blockX(value.getAsInt());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_BLOCKY)) {
                    builder.blockY(value.getAsInt());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_BLOCKZ)) {
                    builder.blockZ(value.getAsInt());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_LOCATIONX)) {
                    builder.locationX(value.getAsDouble());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_LOCATIONY)) {
                    builder.locationY(value.getAsDouble());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_LOCATIONZ)) {
                    builder.locationZ(value.getAsDouble());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_CHUNKX)) {
                    builder.chunkX(value.getAsInt());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_CHUNKZ)) {
                    builder.chunkZ(value.getAsInt());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_PITCH)) {
                    builder.pitch(Float.valueOf(value.getAsFloat()));
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_YAW)) {
                    builder.yaw(Float.valueOf(value.getAsFloat()));
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_VELOCITYX)) {
                    builder.velocityX(value.getAsDouble());
                    continue;
                }
                if (key.equals(NAME_SERIALIZED_VELOCITYY)) {
                    builder.velocityY(value.getAsDouble());
                    continue;
                }
                if (!key.equals(NAME_SERIALIZED_VELOCITYZ)) continue;
                builder.velocityZ(value.getAsDouble());
            }
        }
        return builder.build();
    }

    public String getWorld(boolean calc) {
        return this.world;
    }

    public Integer getBlockX(boolean calc) {
        return PS.getBlockCoord(calc, this.locationX, this.blockX, this.chunkX);
    }

    public Integer getBlockY(boolean calc) {
        return PS.getBlockCoord(calc, this.locationY, this.blockY, null);
    }

    public Integer getBlockZ(boolean calc) {
        return PS.getBlockCoord(calc, this.locationZ, this.blockZ, this.chunkZ);
    }

    public Double getLocationX(boolean calc) {
        return PS.getLocationCoord(calc, this.locationX, this.blockX, this.chunkX);
    }

    public Double getLocationY(boolean calc) {
        return PS.getLocationCoord(calc, this.locationY, this.blockY, null);
    }

    public Double getLocationZ(boolean calc) {
        return PS.getLocationCoord(calc, this.locationZ, this.blockZ, this.chunkZ);
    }

    public Integer getChunkX(boolean calc) {
        return PS.getChunkCoord(calc, this.locationX, this.blockX, this.chunkX);
    }

    public Integer getChunkZ(boolean calc) {
        return PS.getChunkCoord(calc, this.locationZ, this.blockZ, this.chunkZ);
    }

    public Float getPitch(boolean calc) {
        return PS.getPitch(calc, this.pitch);
    }

    public Float getYaw(boolean calc) {
        return PS.getYaw(calc, this.yaw);
    }

    public Double getVelocityX(boolean calc) {
        return PS.getVelocityCoord(calc, this.locationX, this.blockX, this.chunkX, this.velocityX);
    }

    public Double getVelocityY(boolean calc) {
        return PS.getVelocityCoord(calc, this.locationY, this.blockY, null, this.velocityY);
    }

    public Double getVelocityZ(boolean calc) {
        return PS.getVelocityCoord(calc, this.locationZ, this.blockZ, this.chunkZ, this.velocityZ);
    }

    public static Integer getBlockCoord(boolean calc, Double location, Integer block, Integer chunk) {
        if (calc) {
            return PS.calcBlockCoord(location, block, chunk);
        }
        return block;
    }

    public static Double getLocationCoord(boolean calc, Double location, Integer block, Integer chunk) {
        if (calc) {
            return PS.calcLocationCoord(location, block, chunk);
        }
        return location;
    }

    public static Integer getChunkCoord(boolean calc, Double location, Integer block, Integer chunk) {
        if (calc) {
            return PS.calcChunkCoord(location, block, chunk);
        }
        return chunk;
    }

    public static Float getPitch(boolean calc, Float pitch) {
        if (calc) {
            return PS.calcPitch(pitch);
        }
        return pitch;
    }

    public static Float getYaw(boolean calc, Float yaw) {
        if (calc) {
            return PS.calcYaw(yaw);
        }
        return yaw;
    }

    public static Double getVelocityCoord(boolean calc, Double location, Integer block, Integer chunk, Double velocity) {
        if (calc) {
            return PS.calcVelocityCoord(location, block, chunk, velocity);
        }
        return velocity;
    }

    public static Integer calcBlockCoord(Double location, Integer block, Integer chunk) {
        if (block != null) {
            return block;
        }
        if (location != null) {
            return Location.locToBlock((double)location);
        }
        if (chunk != null) {
            return chunk * 16;
        }
        return null;
    }

    public static Double calcLocationCoord(Double location, Integer block, Integer chunk) {
        if (location != null) {
            return location;
        }
        if (block != null) {
            return (double)block;
        }
        if (chunk != null) {
            return (double)chunk.intValue() * 16.0;
        }
        return null;
    }

    public static Integer calcChunkCoord(Double location, Integer block, Integer chunk) {
        if (chunk != null) {
            return chunk;
        }
        if (location != null) {
            return Location.locToBlock((double)location) >> 4;
        }
        if (block != null) {
            return block >> 4;
        }
        return null;
    }

    public static Float calcPitch(Float pitch) {
        if (pitch != null) {
            return pitch;
        }
        return Float.valueOf(0.0f);
    }

    public static Float calcYaw(Float yaw) {
        if (yaw != null) {
            return yaw;
        }
        return Float.valueOf(0.0f);
    }

    public static Double calcVelocityCoord(Double location, Integer block, Integer chunk, Double velocity) {
        if (velocity != null) {
            return velocity;
        }
        if (location != null) {
            return location;
        }
        if (block != null) {
            return (double)block;
        }
        if (chunk != null) {
            return (double)chunk.intValue() * 16.0;
        }
        return null;
    }

    public PS getVelocity() {
        return this.getVelocity(false);
    }

    public PS getVelocity(boolean calc) {
        return new PSBuilder().velocityX(this.getVelocityX(calc)).velocityY(this.getVelocityY(calc)).velocityZ(this.getVelocityZ(calc)).build();
    }

    public PS getBlockCoords() {
        return this.getBlockCoords(false);
    }

    public PS getBlockCoords(boolean calc) {
        return new PSBuilder().blockX(this.getBlockX(calc)).blockY(this.getBlockY(calc)).blockZ(this.getBlockZ(calc)).build();
    }

    public PS getLocationCoords() {
        return this.getLocationCoords(false);
    }

    public PS getLocationCoords(boolean calc) {
        return new PSBuilder().locationX(this.getLocationX(calc)).locationY(this.getLocationY(calc)).locationZ(this.getLocationZ(calc)).build();
    }

    public PS getChunkCoords() {
        return this.getChunkCoords(false);
    }

    public PS getChunkCoords(boolean calc) {
        return new PSBuilder().chunkX(this.getChunkX(calc)).chunkZ(this.getChunkZ(calc)).build();
    }

    public PS getHead() {
        return this.getHead(false);
    }

    public PS getHead(boolean calc) {
        return new PSBuilder().pitch(this.getPitch(calc)).yaw(this.getYaw(calc)).build();
    }

    public PS getBlock() {
        return this.getBlock(false);
    }

    public PS getBlock(boolean calc) {
        return new PSBuilder().world(this.getWorld(calc)).blockX(this.getBlockX(calc)).blockY(this.getBlockY(calc)).blockZ(this.getBlockZ(calc)).build();
    }

    public PS getLocation() {
        return this.getLocation(false);
    }

    public PS getLocation(boolean calc) {
        return new PSBuilder().world(this.getWorld(calc)).locationX(this.getLocationX(calc)).locationY(this.getLocationY(calc)).locationZ(this.getLocationZ(calc)).pitch(this.getPitch(calc)).yaw(this.getYaw(calc)).build();
    }

    public PS getChunk() {
        return this.getChunk(false);
    }

    public PS getChunk(boolean calc) {
        return new PSBuilder().world(this.getWorld(calc)).chunkX(this.getChunkX(calc)).chunkZ(this.getChunkZ(calc)).build();
    }

    public PS getEntity() {
        return this.getEntity(false);
    }

    public PS getEntity(boolean calc) {
        return new PSBuilder().world(this.getWorld(calc)).locationX(this.getLocationX(calc)).locationY(this.getLocationY(calc)).locationZ(this.getLocationZ(calc)).pitch(this.getPitch(calc)).yaw(this.getYaw(calc)).velocityX(this.getVelocityX(false)).velocityY(this.getVelocityY(false)).velocityZ(this.getVelocityZ(false)).build();
    }

    public World asBukkitWorld() throws IllegalStateException {
        return this.asBukkitWorld(false);
    }

    public World asBukkitWorld(boolean calc) throws IllegalStateException {
        return PS.asBukkitWorld(this.getWorld(calc));
    }

    public Block asBukkitBlock() throws IllegalStateException {
        return this.asBukkitBlock(false);
    }

    public Block asBukkitBlock(boolean calc) throws IllegalStateException {
        return PS.asBukkitBlock(this.getBlock(calc));
    }

    public Location asBukkitLocation() throws IllegalStateException {
        return this.asBukkitLocation(false);
    }

    public Location asBukkitLocation(boolean calc) throws IllegalStateException {
        return PS.asBukkitLocation(this.getLocation(calc));
    }

    public Chunk asBukkitChunk() throws IllegalStateException {
        return this.asBukkitChunk(false);
    }

    public Chunk asBukkitChunk(boolean calc) throws IllegalStateException {
        return PS.asBukkitChunk(this.getChunk(calc));
    }

    public Vector asBukkitVelocity() throws IllegalStateException {
        return this.asBukkitVelocity(false);
    }

    public Vector asBukkitVelocity(boolean calc) throws IllegalStateException {
        return PS.asBukkitVelocity(this.getVelocity(calc));
    }

    public static World asBukkitWorld(String world) throws IllegalStateException, NullPointerException {
        if (world == null) {
            throw new NullPointerException("world wasn't set");
        }
        World ret = Bukkit.getWorld((String)world);
        if (ret == null) {
            throw new IllegalStateException("the world " + world + " does not exist on " + MassiveCore.getServerId());
        }
        return ret;
    }

    public static Block asBukkitBlock(PS ps) throws IllegalStateException {
        World world = ps.asBukkitWorld();
        Integer blockX = ps.getBlockX();
        if (blockX == null) {
            throw new IllegalStateException("blockX wasn't set");
        }
        Integer blockY = ps.getBlockY();
        if (blockY == null) {
            throw new IllegalStateException("blockY wasn't set");
        }
        Integer blockZ = ps.getBlockZ();
        if (blockZ == null) {
            throw new IllegalStateException("blockZ wasn't set");
        }
        return world.getBlockAt(blockX.intValue(), blockY.intValue(), blockZ.intValue());
    }

    public static Location asBukkitLocation(PS ps) throws IllegalStateException {
        Float yaw;
        World world = ps.asBukkitWorld();
        Double locationX = ps.getLocationX();
        if (locationX == null) {
            throw new IllegalStateException("locationX wasn't set");
        }
        Double locationY = ps.getLocationY();
        if (locationY == null) {
            throw new IllegalStateException("locationY wasn't set");
        }
        Double locationZ = ps.getLocationZ();
        if (locationZ == null) {
            throw new IllegalStateException("locationZ wasn't set");
        }
        Float pitch = ps.getPitch();
        if (pitch == null) {
            pitch = Float.valueOf(0.0f);
        }
        if ((yaw = ps.getYaw()) == null) {
            yaw = Float.valueOf(0.0f);
        }
        return new Location(world, locationX.doubleValue(), locationY.doubleValue(), locationZ.doubleValue(), yaw.floatValue(), pitch.floatValue());
    }

    public static Chunk asBukkitChunk(PS ps) throws IllegalStateException {
        World world = ps.asBukkitWorld();
        Integer chunkX = ps.getChunkX();
        if (chunkX == null) {
            throw new IllegalStateException("chunkX wasn't set");
        }
        Integer chunkZ = ps.getChunkZ();
        if (chunkZ == null) {
            throw new IllegalStateException("chunkZ wasn't set");
        }
        return world.getChunkAt(chunkX.intValue(), chunkZ.intValue());
    }

    public static Vector asBukkitVelocity(PS ps) throws IllegalStateException {
        Double velocityX = ps.getVelocityX();
        if (velocityX == null) {
            throw new IllegalStateException("velocityX wasn't set");
        }
        Double velocityY = ps.getVelocityY();
        if (velocityY == null) {
            throw new IllegalStateException("velocityY wasn't set");
        }
        Double velocityZ = ps.getVelocityZ();
        if (velocityZ == null) {
            throw new IllegalStateException("velocityZ wasn't set");
        }
        return new Vector(velocityX.doubleValue(), velocityY.doubleValue(), velocityZ.doubleValue());
    }

    public static String calcWorldName(World world) {
        if (world == null) {
            return null;
        }
        return world.getName();
    }

    public static Double trimEntityVelocityY(Double velocityY) {
        if (velocityY == null) {
            return null;
        }
        if (velocityY >= 0.0) {
            return velocityY;
        }
        if (velocityY < -0.1) {
            return velocityY;
        }
        return 0.0;
    }

    public String toString() {
        return this.toString(PSFormatFormal.get());
    }

    public String toString(PSFormat format) {
        return format.format(this);
    }

    public static String toString(PS ps, PSFormat format) {
        return format.format(ps);
    }

    public static Double locationDistanceSquared(PS one, PS two) {
        String w2;
        if (one == null) {
            return null;
        }
        if (two == null) {
            return null;
        }
        String w1 = one.getWorld();
        if (!MUtil.equals(w1, w2 = two.getWorld())) {
            return null;
        }
        Double x1 = one.getLocationX(true);
        if (x1 == null) {
            return null;
        }
        Double y1 = one.getLocationY(true);
        if (y1 == null) {
            return null;
        }
        Double z1 = one.getLocationZ(true);
        if (z1 == null) {
            return null;
        }
        Double x2 = two.getLocationX(true);
        if (x2 == null) {
            return null;
        }
        Double y2 = two.getLocationY(true);
        if (y2 == null) {
            return null;
        }
        Double z2 = two.getLocationZ(true);
        if (z2 == null) {
            return null;
        }
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static Double locationDistance(PS one, PS two) {
        Double ret = PS.locationDistanceSquared(one, two);
        if (ret == null) {
            return null;
        }
        return Math.sqrt(ret);
    }

    public static boolean inSameWorld(PS one, PS two) {
        if (one == null) {
            return false;
        }
        if (two == null) {
            return false;
        }
        String w1 = one.getWorld();
        String w2 = two.getWorld();
        if (w1 == null) {
            return false;
        }
        if (w2 == null) {
            return false;
        }
        return w1.equalsIgnoreCase(w2);
    }

    public static boolean inSameUniverse(PS one, PS two, Multiverse multiverse) {
        if (one == null) {
            return false;
        }
        if (two == null) {
            return false;
        }
        String w1 = one.getWorld();
        String w2 = two.getWorld();
        if (w1 == null) {
            return false;
        }
        if (w2 == null) {
            return false;
        }
        String m1 = multiverse.getUniverseForWorldName(w1);
        String m2 = multiverse.getUniverseForWorldName(w2);
        return m1.equalsIgnoreCase(m2);
    }

    public static boolean inSameUniverse(PS one, PS two, Aspect aspect) {
        return PS.inSameUniverse(one, two, aspect.getMultiverse());
    }

    public static Set<PS> getDistinctChunks(Collection<PS> pss) {
        LinkedHashSet<PS> ret = new LinkedHashSet<PS>();
        for (PS ps : pss) {
            ret.add(ps.getChunk(true));
        }
        return ret;
    }

    public int hashCode() {
        if (!this.hashed) {
            this.hashcode = this.calcHashCode();
            this.hashed = true;
        }
        return this.hashcode;
    }

    public int calcHashCode() {
        return PS.calcHashCode(this);
    }

    public static int calcHashCode(PS ps) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (ps.blockX == null ? 0 : ps.blockX.hashCode());
        result = 31 * result + (ps.blockY == null ? 0 : ps.blockY.hashCode());
        result = 31 * result + (ps.blockZ == null ? 0 : ps.blockZ.hashCode());
        result = 31 * result + (ps.chunkX == null ? 0 : ps.chunkX.hashCode());
        result = 31 * result + (ps.chunkZ == null ? 0 : ps.chunkZ.hashCode());
        result = 31 * result + (ps.locationX == null ? 0 : ps.locationX.hashCode());
        result = 31 * result + (ps.locationY == null ? 0 : ps.locationY.hashCode());
        result = 31 * result + (ps.locationZ == null ? 0 : ps.locationZ.hashCode());
        result = 31 * result + (ps.pitch == null ? 0 : ps.pitch.hashCode());
        result = 31 * result + (ps.velocityX == null ? 0 : ps.velocityX.hashCode());
        result = 31 * result + (ps.velocityY == null ? 0 : ps.velocityY.hashCode());
        result = 31 * result + (ps.velocityZ == null ? 0 : ps.velocityZ.hashCode());
        result = 31 * result + (ps.world == null ? 0 : ps.world.hashCode());
        result = 31 * result + (ps.yaw == null ? 0 : ps.yaw.hashCode());
        return result;
    }

    public boolean equals(Object derpObject) {
        return PS.equals(this, derpObject);
    }

    public static boolean equals(PS herp, Object derpObject) {
        return PS.compareTo(herp, derpObject) == 0;
    }

    @Override
    public int compareTo(PS derp) {
        return PS.compareTo(this, derp);
    }

    public static int compareTo(PS herp, Object derpObject) {
        if (herp == null && derpObject == null) {
            return 0;
        }
        if (herp == null) {
            return -1;
        }
        if (derpObject == null) {
            return 1;
        }
        if (!(derpObject instanceof PS)) {
            return -1;
        }
        PS derp = (PS)derpObject;
        int ret = MUtil.compare(herp.world, derp.world);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.chunkX, derp.chunkX);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.chunkZ, derp.chunkZ);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.blockX, derp.blockX);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.blockY, derp.blockY);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.blockZ, derp.blockZ);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.locationX, derp.locationX);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.locationX, derp.locationX);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.locationZ, derp.locationZ);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.pitch, derp.pitch);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.yaw, derp.yaw);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.velocityX, derp.velocityX);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.velocityY, derp.velocityY);
        if (ret != 0) {
            return ret;
        }
        ret = MUtil.compare(herp.velocityZ, derp.velocityZ);
        if (ret != 0) {
            return ret;
        }
        return 0;
    }

    public PS clone() {
        return this;
    }
}

