/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.ps;

import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.ps.PS;
import com.massivecraft.massivecore.ps.PSFormat;
import com.massivecraft.massivecore.util.Txt;
import java.util.ArrayList;
import java.util.List;

public class PSFormatAbstract
implements PSFormat {
    private final String strNull;
    private final String strStart;
    private final boolean useWorldDisplayname;
    private final boolean useWorldAlias;
    private final String formatWorld;
    private final String formatBlockX;
    private final String formatBlockY;
    private final String formatBlockZ;
    private final String formatLocationX;
    private final String formatLocationY;
    private final String formatLocationZ;
    private final String formatChunkX;
    private final String formatChunkZ;
    private final String formatPitch;
    private final String formatYaw;
    private final String formatVelocityX;
    private final String formatVelocityY;
    private final String formatVelocityZ;
    private final String strGlue;
    private final String strStop;

    public PSFormatAbstract(String strNull, String strStart, boolean useWorldDisplayname, boolean useWorldAlias, String formatWorld, String formatBlockX, String formatBlockY, String formatBlockZ, String formatLocationX, String formatLocationY, String formatLocationZ, String formatChunkX, String formatChunkZ, String formatPitch, String formatYaw, String formatVelocityX, String formatVelocityY, String formatVelocityZ, String strGlue, String strStop) {
        this.strNull = strNull;
        this.strStart = strStart;
        this.useWorldDisplayname = useWorldDisplayname;
        this.useWorldAlias = useWorldAlias;
        this.formatWorld = formatWorld;
        this.formatBlockX = formatBlockX;
        this.formatBlockY = formatBlockY;
        this.formatBlockZ = formatBlockZ;
        this.formatLocationX = formatLocationX;
        this.formatLocationY = formatLocationY;
        this.formatLocationZ = formatLocationZ;
        this.formatChunkX = formatChunkX;
        this.formatChunkZ = formatChunkZ;
        this.formatPitch = formatPitch;
        this.formatYaw = formatYaw;
        this.formatVelocityX = formatVelocityX;
        this.formatVelocityY = formatVelocityY;
        this.formatVelocityZ = formatVelocityZ;
        this.strGlue = strGlue;
        this.strStop = strStop;
    }

    @Override
    public String format(PS ps) {
        if (ps == null) {
            return this.strNull;
        }
        List<String> entries = this.formatEntries(ps);
        return this.strStart + Txt.implode(entries, this.strGlue) + this.strStop;
    }

    public List<String> formatEntries(PS ps) {
        ArrayList<String> ret = new ArrayList<String>();
        Object val = null;
        val = ps.getWorld();
        if (val != null) {
            if (this.useWorldDisplayname) {
                val = Mixin.getWorldDisplayName(val.toString());
            } else if (this.useWorldAlias) {
                val = Mixin.getWorldAliasOrId(val.toString());
            }
            ret.add(String.format(this.formatWorld, val));
        }
        if ((val = ps.getBlockX()) != null) {
            ret.add(String.format(this.formatBlockX, val));
        }
        if ((val = ps.getBlockY()) != null) {
            ret.add(String.format(this.formatBlockY, val));
        }
        if ((val = ps.getBlockZ()) != null) {
            ret.add(String.format(this.formatBlockZ, val));
        }
        if ((val = ps.getLocationX()) != null) {
            ret.add(String.format(this.formatLocationX, val));
        }
        if ((val = ps.getLocationY()) != null) {
            ret.add(String.format(this.formatLocationY, val));
        }
        if ((val = ps.getLocationZ()) != null) {
            ret.add(String.format(this.formatLocationZ, val));
        }
        if ((val = ps.getChunkX()) != null) {
            ret.add(String.format(this.formatChunkX, val));
        }
        if ((val = ps.getChunkZ()) != null) {
            ret.add(String.format(this.formatChunkZ, val));
        }
        if ((val = ps.getPitch()) != null) {
            ret.add(String.format(this.formatPitch, val));
        }
        if ((val = ps.getYaw()) != null) {
            ret.add(String.format(this.formatYaw, val));
        }
        if ((val = ps.getVelocityX()) != null) {
            ret.add(String.format(this.formatVelocityX, val));
        }
        if ((val = ps.getVelocityY()) != null) {
            ret.add(String.format(this.formatVelocityY, val));
        }
        if ((val = ps.getVelocityZ()) != null) {
            ret.add(String.format(this.formatVelocityZ, val));
        }
        return ret;
    }
}

