/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.store;

import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.store.Db;
import com.massivecraft.massivecore.store.DbFlatfile;
import com.massivecraft.massivecore.store.DriverAbstract;
import com.massivecraft.massivecore.store.JsonFileFilter;
import com.massivecraft.massivecore.util.DiscUtil;
import com.massivecraft.massivecore.xlib.gson.JsonElement;
import com.massivecraft.massivecore.xlib.gson.JsonParser;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DriverFlatfile
extends DriverAbstract {
    private static final String DOTJSON = ".json";
    public static final String NAME = "flatfile";
    private static DriverFlatfile i = new DriverFlatfile();

    public static DriverFlatfile get() {
        return i;
    }

    private DriverFlatfile() {
        super(NAME);
    }

    @Override
    public Db getDb(String uri) {
        File folder = new File(uri.substring(NAME.length() + 3));
        folder.mkdirs();
        return new DbFlatfile(this, folder);
    }

    @Override
    public Set<String> getCollnames(Db db) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (File f : ((DbFlatfile)db).dir.listFiles()) {
            if (!f.isDirectory()) continue;
            ret.add(f.getName());
        }
        return ret;
    }

    @Override
    public boolean renameColl(Db db, String from, String to) {
        File dir = ((DbFlatfile)db).dir;
        File fileFrom = new File(dir, from);
        File fileTo = new File(dir, to);
        return fileFrom.renameTo(fileTo);
    }

    @Override
    public boolean containsId(Coll<?> coll, String id) {
        return DriverFlatfile.fileFromId(coll, id).isFile();
    }

    @Override
    public Long getMtime(Coll<?> coll, String id) {
        File file = DriverFlatfile.fileFromId(coll, id);
        if (!file.isFile()) {
            return null;
        }
        return file.lastModified();
    }

    @Override
    public Collection<String> getIds(Coll<?> coll) {
        ArrayList<String> ret = new ArrayList<String>();
        File collDir = DriverFlatfile.getCollDir(coll);
        if (!collDir.isDirectory()) {
            return ret;
        }
        for (File file : collDir.listFiles(JsonFileFilter.get())) {
            ret.add(DriverFlatfile.idFromFile(file));
        }
        return ret;
    }

    @Override
    public Map<String, Long> getId2mtime(Coll<?> coll) {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        File collDir = DriverFlatfile.getCollDir(coll);
        if (!collDir.isDirectory()) {
            return ret;
        }
        for (File file : collDir.listFiles(JsonFileFilter.get())) {
            String id = DriverFlatfile.idFromFile(file);
            long mtime = file.lastModified();
            ret.put(id, mtime);
        }
        return ret;
    }

    @Override
    public Map.Entry<JsonElement, Long> load(Coll<?> coll, String id) {
        File file = DriverFlatfile.fileFromId(coll, id);
        return this.loadFile(file);
    }

    public Map.Entry<JsonElement, Long> loadFile(File file) {
        Long mtime = file.lastModified();
        if (mtime == 0L) {
            return null;
        }
        JsonElement raw = this.loadFileJson(file);
        if (raw == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<JsonElement, Long>(raw, mtime);
    }

    public JsonElement loadFileJson(File file) {
        String content = DiscUtil.readCatch(file);
        if (content == null) {
            return null;
        }
        if ((content = content.trim()).length() == 0) {
            return null;
        }
        return new JsonParser().parse(content);
    }

    @Override
    public Map<String, Map.Entry<JsonElement, Long>> loadAll(Coll<?> coll) {
        LinkedHashMap<String, Map.Entry<JsonElement, Long>> ret = null;
        File collDir = DriverFlatfile.getCollDir(coll);
        if (!collDir.isDirectory()) {
            return ret;
        }
        File[] files = collDir.listFiles(JsonFileFilter.get());
        ret = new LinkedHashMap<String, Map.Entry<JsonElement, Long>>(files.length);
        for (File file : files) {
            String id = DriverFlatfile.idFromFile(file);
            Map.Entry<JsonElement, Long> entry = this.loadFile(file);
            ret.put(id, entry);
        }
        return ret;
    }

    @Override
    public Long save(Coll<?> coll, String id, JsonElement data) {
        String content;
        File file = DriverFlatfile.fileFromId(coll, id);
        if (!DiscUtil.writeCatch(file, content = coll.getGson().toJson(data))) {
            return null;
        }
        return file.lastModified();
    }

    @Override
    public void delete(Coll<?> coll, String id) {
        File file = DriverFlatfile.fileFromId(coll, id);
        file.delete();
    }

    public static File getCollDir(Coll<?> coll) {
        return (File)coll.getCollDriverObject();
    }

    public static String idFromFile(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        return name.substring(0, name.length() - 5);
    }

    public static File fileFromId(Coll<?> coll, String id) {
        File collDir = DriverFlatfile.getCollDir(coll);
        File idFile = new File(collDir, id + DOTJSON);
        return idFile;
    }
}

