/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.store;

import com.massivecraft.massivecore.MassiveCoreMConf;
import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.store.Db;
import com.massivecraft.massivecore.store.DbMongo;
import com.massivecraft.massivecore.store.DriverAbstract;
import com.massivecraft.massivecore.store.GsonMongoConverter;
import com.massivecraft.massivecore.xlib.gson.JsonElement;
import com.massivecraft.massivecore.xlib.gson.JsonObject;
import com.massivecraft.massivecore.xlib.mongodb.BasicDBObject;
import com.massivecraft.massivecore.xlib.mongodb.DB;
import com.massivecraft.massivecore.xlib.mongodb.DBCollection;
import com.massivecraft.massivecore.xlib.mongodb.DBCursor;
import com.massivecraft.massivecore.xlib.mongodb.DBObject;
import com.massivecraft.massivecore.xlib.mongodb.MongoClient;
import com.massivecraft.massivecore.xlib.mongodb.MongoClientURI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DriverMongo
extends DriverAbstract {
    public static final String ID_FIELD = "_id";
    public static final String MTIME_FIELD = "_mtime";
    public static final BasicDBObject dboEmpty = new BasicDBObject();
    public static final BasicDBObject dboKeysId = new BasicDBObject().append("_id", 1);
    public static final BasicDBObject dboKeysMtime = new BasicDBObject().append("_mtime", 1);
    public static final BasicDBObject dboKeysIdandMtime = new BasicDBObject().append("_id", 1).append("_mtime", 1);
    protected static DriverMongo i = new DriverMongo();

    public static DriverMongo get() {
        return i;
    }

    private DriverMongo() {
        super("mongodb");
    }

    @Override
    public Db getDb(String uri) {
        DB db = this.getDbInner(uri);
        return new DbMongo(this, db);
    }

    @Override
    public Set<String> getCollnames(Db db) {
        Set<String> ret = ((DbMongo)db).db.getCollectionNames();
        ret.remove("system.indexes");
        return ret;
    }

    @Override
    public boolean renameColl(Db db, String from, String to) {
        if (!this.getCollnames(db).contains(from)) {
            return false;
        }
        if (this.getCollnames(db).contains(to)) {
            return false;
        }
        DB mdb = ((DbMongo)db).db;
        mdb.getCollection(from).rename(to);
        return true;
    }

    @Override
    public boolean containsId(Coll<?> coll, String id) {
        DBCollection dbcoll = DriverMongo.fixColl(coll);
        DBCursor cursor = dbcoll.find(new BasicDBObject(ID_FIELD, id));
        return cursor.count() != 0;
    }

    @Override
    public Long getMtime(Coll<?> coll, String id) {
        DBCollection dbcoll = DriverMongo.fixColl(coll);
        BasicDBObject found = (BasicDBObject)dbcoll.findOne(new BasicDBObject(ID_FIELD, id), (DBObject)dboKeysMtime);
        if (found == null) {
            return null;
        }
        long mtime = found.getLong(MTIME_FIELD, 0L);
        return mtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getIds(Coll<?> coll) {
        ArrayList<String> ret = null;
        DBCollection dbcoll = DriverMongo.fixColl(coll);
        DBCursor cursor = dbcoll.find(dboEmpty, dboKeysId);
        try {
            ret = new ArrayList<String>(cursor.count());
            while (cursor.hasNext()) {
                Object remoteId = cursor.next().get(ID_FIELD);
                ret.add(remoteId.toString());
            }
        }
        finally {
            cursor.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> getId2mtime(Coll<?> coll) {
        HashMap<String, Long> ret = null;
        DBCollection dbcoll = DriverMongo.fixColl(coll);
        DBCursor cursor = dbcoll.find(dboEmpty, dboKeysIdandMtime);
        try {
            ret = new HashMap<String, Long>(cursor.count());
            while (cursor.hasNext()) {
                BasicDBObject raw = (BasicDBObject)cursor.next();
                Object remoteId = raw.get(ID_FIELD);
                long mtime = raw.getLong(MTIME_FIELD, 0L);
                ret.put(remoteId.toString(), mtime);
            }
        }
        finally {
            cursor.close();
        }
        return ret;
    }

    @Override
    public Map.Entry<JsonElement, Long> load(Coll<?> coll, String id) {
        DBCollection dbcoll = DriverMongo.fixColl(coll);
        BasicDBObject raw = (BasicDBObject)dbcoll.findOne(new BasicDBObject(ID_FIELD, id));
        return this.loadRaw(raw);
    }

    public Map.Entry<JsonElement, Long> loadRaw(BasicDBObject raw) {
        if (raw == null) {
            return null;
        }
        raw.removeField(ID_FIELD);
        Long mtime = 0L;
        Object mtimeObject = raw.removeField(MTIME_FIELD);
        if (mtimeObject != null) {
            mtime = ((Number)mtimeObject).longValue();
        }
        JsonObject element = GsonMongoConverter.mongo2GsonObject(raw);
        return new AbstractMap.SimpleEntry<JsonElement, Long>(element, mtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map.Entry<JsonElement, Long>> loadAll(Coll<?> coll) {
        LinkedHashMap<String, Map.Entry<JsonElement, Long>> ret = null;
        DBCollection dbcoll = DriverMongo.fixColl(coll);
        DBCursor cursor = dbcoll.find();
        try {
            ret = new LinkedHashMap<String, Map.Entry<JsonElement, Long>>(cursor.count());
            while (cursor.hasNext()) {
                BasicDBObject raw = (BasicDBObject)cursor.next();
                Object rawId = raw.removeField(ID_FIELD);
                if (rawId == null) continue;
                String id = rawId.toString();
                Map.Entry<JsonElement, Long> entry = this.loadRaw(raw);
                ret.put(id, entry);
            }
        }
        finally {
            cursor.close();
        }
        return ret;
    }

    @Override
    public Long save(Coll<?> coll, String id, JsonElement data) {
        DBCollection dbcoll = DriverMongo.fixColl(coll);
        BasicDBObject dbo = new BasicDBObject();
        Long mtime = System.currentTimeMillis();
        dbo.put(ID_FIELD, (Object)id);
        dbo.put(MTIME_FIELD, (Object)mtime);
        GsonMongoConverter.gson2MongoObject(data, dbo);
        dbcoll.save(dbo, MassiveCoreMConf.get().getMongoDbWriteConcernSave());
        return mtime;
    }

    @Override
    public void delete(Coll<?> coll, String id) {
        DBCollection dbcoll = DriverMongo.fixColl(coll);
        dbcoll.remove(new BasicDBObject(ID_FIELD, id), MassiveCoreMConf.get().getMongoDbWriteConcernDelete());
    }

    protected static DBCollection fixColl(Coll<?> coll) {
        return (DBCollection)coll.getCollDriverObject();
    }

    protected DB getDbInner(String uri) {
        MongoClientURI muri = new MongoClientURI(uri);
        try {
            MongoClient mongoClient = new MongoClient(muri);
            DB db = mongoClient.getDB(muri.getDatabase());
            if (muri.getUsername() == null) {
                return db;
            }
            if (!db.authenticate(muri.getUsername(), muri.getPassword())) {
                return null;
            }
            return db;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

