/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.store;

import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.NaturalOrderComparator;
import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.store.ModificationState;
import com.massivecraft.massivecore.store.accessor.Accessor;
import com.massivecraft.massivecore.xlib.gson.Gson;
import com.massivecraft.massivecore.xlib.gson.JsonObject;

public abstract class Entity<E extends Entity<E>>
implements Comparable<E> {
    protected transient Coll<E> coll;
    protected transient String id;
    private JsonObject customData = null;

    protected void setColl(Coll<E> val) {
        this.coll = val;
    }

    public Coll<E> getColl() {
        return this.coll;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getUniverse() {
        Coll<E> coll = this.getColl();
        if (coll == null) {
            return null;
        }
        return coll.getUniverse();
    }

    public JsonObject getCustomData() {
        return this.customData;
    }

    public void setCustomData(JsonObject customData) {
        this.customData = customData;
    }

    public String attach(Coll<E> coll) {
        return coll.attach(this);
    }

    public E detach() {
        Coll<E> coll = this.getColl();
        if (coll == null) {
            return (E)this;
        }
        return (E)((Entity)coll.detachEntity(this));
    }

    public boolean attached() {
        return this.getColl() != null && this.getId() != null;
    }

    public boolean detached() {
        return !this.attached();
    }

    public void preAttach(String id) {
    }

    public void postAttach(String id) {
    }

    public void preDetach(String id) {
    }

    public void postDetach(String id) {
    }

    public void changed() {
        String id = this.getId();
        if (id == null) {
            return;
        }
        Coll<E> coll = this.getColl();
        if (coll == null) {
            return;
        }
        if (!coll.inited()) {
            return;
        }
        coll.changedIds.add(id);
    }

    public ModificationState sync() {
        String id = this.getId();
        if (id == null) {
            return ModificationState.UNKNOWN;
        }
        return this.getColl().syncId(id);
    }

    public void saveToRemote() {
        String id = this.getId();
        if (id == null) {
            return;
        }
        this.getColl().saveToRemote(id);
    }

    public void loadFromRemote() {
        String id = this.getId();
        if (id == null) {
            return;
        }
        this.getColl().loadFromRemote(id, null, false);
    }

    public E load(E that) {
        Accessor.get(this.getClass()).copy(that, this);
        return (E)this;
    }

    public boolean isDefault() {
        return false;
    }

    @Override
    public int compareTo(E that) {
        if (that == null) {
            throw new NullPointerException("You cannot compare with null");
        }
        if (this.equals(that)) {
            return 0;
        }
        String thisId = this.getId();
        String thatId = ((Entity)that).getId();
        if (thisId == null) {
            return -1;
        }
        if (thatId == null) {
            return 1;
        }
        int ret = NaturalOrderComparator.get().compare(thisId, thatId);
        if (ret == 0) {
            ret = -1;
        }
        return ret;
    }

    public String toString() {
        Gson gson = MassiveCore.gson;
        Coll<E> coll = this.getColl();
        if (coll != null) {
            gson = coll.getGson();
        }
        return this.getClass().getSimpleName() + gson.toJson((Object)this, this.getClass());
    }
}

