/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.store;

import com.massivecraft.massivecore.xlib.gson.JsonArray;
import com.massivecraft.massivecore.xlib.gson.JsonElement;
import com.massivecraft.massivecore.xlib.gson.JsonNull;
import com.massivecraft.massivecore.xlib.gson.JsonObject;
import com.massivecraft.massivecore.xlib.gson.JsonPrimitive;
import com.massivecraft.massivecore.xlib.gson.internal.LazilyParsedNumber;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GsonEqualsChecker {
    public static boolean equals(JsonElement one, Object twoObject) {
        if (twoObject == null) {
            return false;
        }
        if (one == twoObject) {
            return true;
        }
        if (one.isJsonObject()) {
            return GsonEqualsChecker.objectEquals((JsonObject)one, twoObject);
        }
        if (one.isJsonArray()) {
            return GsonEqualsChecker.arrayEquals((JsonArray)one, twoObject);
        }
        if (one.isJsonPrimitive()) {
            return GsonEqualsChecker.primitiveEquals((JsonPrimitive)one, twoObject);
        }
        if (one.isJsonNull()) {
            return GsonEqualsChecker.nullEquals((JsonNull)one, twoObject);
        }
        throw new IllegalArgumentException("Unsupported value type for: " + one);
    }

    public static boolean objectEquals(JsonObject one, Object twoObject) {
        if (twoObject == null) {
            return false;
        }
        if (one == twoObject) {
            return true;
        }
        if (!(twoObject instanceof JsonObject)) {
            return false;
        }
        JsonObject two = (JsonObject)twoObject;
        if (one.entrySet().size() != two.entrySet().size()) {
            return false;
        }
        for (Map.Entry<String, JsonElement> entry : one.entrySet()) {
            if (GsonEqualsChecker.equals(entry.getValue(), two.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static boolean arrayEquals(JsonArray one, Object twoObject) {
        if (twoObject == null) {
            return false;
        }
        if (one == twoObject) {
            return true;
        }
        if (!(twoObject instanceof JsonArray)) {
            return false;
        }
        JsonArray two = (JsonArray)twoObject;
        int size = one.size();
        if (two.size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (GsonEqualsChecker.equals(one.get(i), two.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean primitiveEquals(JsonPrimitive one, Object twoObject) {
        if (twoObject == null) {
            return false;
        }
        if (one == twoObject) {
            return true;
        }
        if (!(twoObject instanceof JsonPrimitive)) {
            return false;
        }
        JsonPrimitive two = (JsonPrimitive)twoObject;
        if (one.isBoolean()) {
            return one.getAsBoolean() == two.getAsBoolean();
        }
        if (one.isNumber()) {
            Number oneNumber = one.getAsNumber();
            Number twoNumber = two.getAsNumber();
            boolean floating = GsonEqualsChecker.isFloating(oneNumber);
            if (floating) {
                return Math.abs(oneNumber.doubleValue() - twoNumber.doubleValue()) < 1.0E-4;
            }
            return oneNumber.longValue() == twoNumber.longValue();
        }
        if (one.isString()) {
            return one.getAsString().equals(two.getAsString());
        }
        throw new IllegalArgumentException("Unsupported value type for: " + one);
    }

    public static boolean nullEquals(JsonNull one, Object twoObject) {
        if (twoObject == null) {
            return false;
        }
        return twoObject == JsonNull.INSTANCE;
    }

    public static boolean isFloating(Number number) {
        if (number instanceof LazilyParsedNumber) {
            return StringUtils.contains((String)number.toString(), (char)'.');
        }
        return number instanceof Double || number instanceof Float;
    }
}

