/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.store;

import com.massivecraft.massivecore.xlib.bson.types.ObjectId;
import com.massivecraft.massivecore.xlib.gson.JsonArray;
import com.massivecraft.massivecore.xlib.gson.JsonElement;
import com.massivecraft.massivecore.xlib.gson.JsonNull;
import com.massivecraft.massivecore.xlib.gson.JsonObject;
import com.massivecraft.massivecore.xlib.gson.JsonPrimitive;
import com.massivecraft.massivecore.xlib.gson.internal.LazilyParsedNumber;
import com.massivecraft.massivecore.xlib.mongodb.BasicDBList;
import com.massivecraft.massivecore.xlib.mongodb.BasicDBObject;
import com.massivecraft.massivecore.xlib.mongodb.DBObject;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class GsonMongoConverter {
    public static final String DOT_NORMAL = ".";
    public static final String DOT_MONGO = "<dot>";
    public static final String DOLLAR_NORMAL = "$";
    public static final String DOLLAR_MONGO = "<dollar>";

    public static String gson2MongoKey(String key) {
        key = StringUtils.replace((String)key, (String)DOT_NORMAL, (String)DOT_MONGO);
        key = StringUtils.replace((String)key, (String)DOLLAR_NORMAL, (String)DOLLAR_MONGO);
        return key;
    }

    public static BasicDBObject gson2MongoObject(JsonElement inElement, BasicDBObject out) {
        JsonObject in = inElement.getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : in.entrySet()) {
            String key = GsonMongoConverter.gson2MongoKey(entry.getKey());
            JsonElement val = entry.getValue();
            if (val.isJsonArray()) {
                out.put(key, (Object)GsonMongoConverter.gson2MongoArray(val));
                continue;
            }
            if (val.isJsonObject()) {
                out.put(key, (Object)GsonMongoConverter.gson2MongoObject(val));
                continue;
            }
            out.put(key, GsonMongoConverter.gson2MongoPrimitive(val));
        }
        return out;
    }

    public static BasicDBObject gson2MongoObject(JsonElement inElement) {
        return GsonMongoConverter.gson2MongoObject(inElement, new BasicDBObject());
    }

    public static BasicDBList gson2MongoArray(JsonElement inElement) {
        JsonArray in = inElement.getAsJsonArray();
        BasicDBList out = new BasicDBList();
        for (int i = 0; i < in.size(); ++i) {
            JsonElement element = in.get(i);
            if (element.isJsonArray()) {
                out.add(GsonMongoConverter.gson2MongoArray(element));
                continue;
            }
            if (element.isJsonObject()) {
                out.add(GsonMongoConverter.gson2MongoObject(element));
                continue;
            }
            out.add(GsonMongoConverter.gson2MongoPrimitive(element));
        }
        return out;
    }

    public static Object gson2MongoPrimitive(JsonElement inElement) {
        if (inElement.isJsonNull()) {
            return null;
        }
        JsonPrimitive in = inElement.getAsJsonPrimitive();
        if (in.isBoolean()) {
            return in.getAsBoolean();
        }
        if (in.isNumber()) {
            boolean floating;
            Number number = in.getAsNumber();
            if (number instanceof LazilyParsedNumber) {
                floating = StringUtils.contains((String)number.toString(), (char)'.');
            } else {
                boolean bl = floating = number instanceof Double || number instanceof Float;
            }
            if (floating) {
                return number.doubleValue();
            }
            return number.longValue();
        }
        if (in.isString()) {
            return in.getAsString();
        }
        throw new IllegalArgumentException("Unsupported value type for: " + in);
    }

    public static String mongo2GsonKey(String key) {
        key = StringUtils.replace((String)key, (String)DOT_MONGO, (String)DOT_NORMAL);
        key = StringUtils.replace((String)key, (String)DOLLAR_MONGO, (String)DOLLAR_NORMAL);
        return key;
    }

    public static JsonObject mongo2GsonObject(DBObject inObject) {
        if (!(inObject instanceof BasicDBObject)) {
            throw new IllegalArgumentException("Expected BasicDBObject as argument type!");
        }
        BasicDBObject in = (BasicDBObject)inObject;
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry entry : in.entrySet()) {
            String key = GsonMongoConverter.mongo2GsonKey((String)entry.getKey());
            Object val = entry.getValue();
            if (val instanceof BasicDBList) {
                jsonObject.add(key, GsonMongoConverter.mongo2GsonArray((BasicDBList)val));
                continue;
            }
            if (val instanceof BasicDBObject) {
                jsonObject.add(key, GsonMongoConverter.mongo2GsonObject((BasicDBObject)val));
                continue;
            }
            jsonObject.add(key, GsonMongoConverter.mongo2GsonPrimitive(val));
        }
        return jsonObject;
    }

    public static JsonArray mongo2GsonArray(DBObject inObject) {
        if (!(inObject instanceof BasicDBList)) {
            throw new IllegalArgumentException("Expected BasicDBList as argument type!");
        }
        BasicDBList in = (BasicDBList)inObject;
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < in.size(); ++i) {
            Object object = in.get(i);
            if (object instanceof BasicDBList) {
                jsonArray.add(GsonMongoConverter.mongo2GsonArray((BasicDBList)object));
                continue;
            }
            if (object instanceof BasicDBObject) {
                jsonArray.add(GsonMongoConverter.mongo2GsonObject((BasicDBObject)object));
                continue;
            }
            jsonArray.add(GsonMongoConverter.mongo2GsonPrimitive(object));
        }
        return jsonArray;
    }

    public static JsonElement mongo2GsonPrimitive(Object inObject) {
        if (inObject == null) {
            return JsonNull.INSTANCE;
        }
        if (inObject instanceof Boolean) {
            return new JsonPrimitive((Boolean)inObject);
        }
        if (inObject instanceof Number) {
            return new JsonPrimitive((Number)inObject);
        }
        if (inObject instanceof String) {
            return new JsonPrimitive((String)inObject);
        }
        if (inObject instanceof Character) {
            return new JsonPrimitive((Character)inObject);
        }
        if (inObject instanceof ObjectId) {
            return new JsonPrimitive(inObject.toString());
        }
        throw new IllegalArgumentException("Unsupported value type for: " + inObject);
    }
}

