/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.store;

import com.massivecraft.massivecore.ConfServer;
import com.massivecraft.massivecore.store.Db;
import com.massivecraft.massivecore.store.Driver;
import com.massivecraft.massivecore.store.DriverFlatfile;
import com.massivecraft.massivecore.store.DriverMongo;
import com.massivecraft.massivecore.store.GsonEqualsChecker;
import com.massivecraft.massivecore.xlib.gson.JsonElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class MStore {
    private static Map<String, Driver> drivers = new HashMap<String, Driver>();
    private static Map<String, Db> uri2db;

    public static boolean registerDriver(Driver driver) {
        if (drivers.containsKey(driver.getName())) {
            return false;
        }
        drivers.put(driver.getName(), driver);
        return true;
    }

    public static Driver getDriver(String id) {
        return drivers.get(id);
    }

    public static String createId() {
        return UUID.randomUUID().toString();
    }

    public static boolean equal(JsonElement one, JsonElement two) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return one == null;
        }
        return GsonEqualsChecker.equals(one, two);
    }

    public static String resolveAlias(String alias) {
        String uri = ConfServer.alias2uri.get(alias);
        if (uri == null) {
            return alias;
        }
        return MStore.resolveAlias(uri);
    }

    public static Db getDb(String alias) {
        String uri = MStore.resolveAlias(alias);
        Db db = uri2db.get(uri);
        if (db != null) {
            return db;
        }
        try {
            db = MStore.getDb(new URI(uri));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        uri2db.put(uri, db);
        return db;
    }

    public static Db getDb() {
        return MStore.getDb(ConfServer.dburi);
    }

    public static Db getDb(URI uri) {
        String scheme = uri.getScheme();
        Driver driver = MStore.getDriver(scheme);
        if (driver == null) {
            return null;
        }
        return driver.getDb(uri.toString());
    }

    static {
        MStore.registerDriver(DriverMongo.get());
        MStore.registerDriver(DriverFlatfile.get());
        uri2db = new HashMap<String, Db>();
    }
}

