/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.store;

import com.massivecraft.massivecore.Predictate;
import com.massivecraft.massivecore.cmd.arg.ARSenderEntity;
import com.massivecraft.massivecore.cmd.arg.ARSenderId;
import com.massivecraft.massivecore.store.Coll;
import com.massivecraft.massivecore.store.Db;
import com.massivecraft.massivecore.store.SenderEntity;
import com.massivecraft.massivecore.store.SenderIdSource;
import com.massivecraft.massivecore.util.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class SenderColl<E extends SenderEntity<E>>
extends Coll<E>
implements SenderIdSource {
    public SenderColl(String name, Class<E> entityClass, Db db, Plugin plugin, boolean lazy, boolean creative, boolean lowercasing, Comparator<? super String> idComparator, Comparator<? super E> entityComparator) {
        super(name, entityClass, db, plugin, lazy, creative, lowercasing, idComparator, entityComparator);
    }

    public SenderColl(String name, Class<E> entityClass, Db db, Plugin plugin, boolean lazy, boolean creative, boolean lowercasing) {
        super(name, entityClass, db, plugin, lazy, creative, lowercasing);
    }

    public SenderColl(String name, Class<E> entityClass, Db db, Plugin plugin) {
        super(name, entityClass, db, plugin, true, true, true);
    }

    @Override
    public String fixId(Object oid) {
        if (oid == null) {
            return null;
        }
        String ret = null;
        if (oid instanceof String) {
            ret = (String)oid;
        } else if (oid.getClass() == this.entityClass) {
            ret = (String)this.entity2id.get(oid);
        }
        if (ret == null) {
            ret = IdUtil.getId(oid);
        }
        if (ret == null) {
            return null;
        }
        if (this.isLowercasing()) {
            ret = ret.toLowerCase();
        }
        return ret;
    }

    @Override
    public Collection<Collection<String>> getSenderIdCollections() {
        ArrayList<Collection<String>> ret = new ArrayList<Collection<String>>();
        ret.add(this.getIds());
        if (this.isCreative()) {
            ret.add(IdUtil.getAllIds());
        }
        return ret;
    }

    public ARSenderEntity<E> getAREntity() {
        return ARSenderEntity.get(this);
    }

    public ARSenderEntity<E> getAREntity(boolean online) {
        return ARSenderEntity.get(this, online);
    }

    public ARSenderId getARId() {
        return ARSenderId.get(this);
    }

    public ARSenderId getARId(boolean online) {
        return ARSenderId.get(this, online);
    }

    public Collection<E> getAllOnline() {
        return this.getAll(new Predictate<E>(){

            @Override
            public boolean apply(E entity) {
                return ((SenderEntity)entity).isOnline();
            }
        });
    }

    public Collection<E> getAllOffline() {
        return this.getAll(new Predictate<E>(){

            @Override
            public boolean apply(E entity) {
                return ((SenderEntity)entity).isOffline();
            }
        });
    }

    protected void setSenderReference(String senderId, CommandSender sender) {
        SenderEntity senderEntity = (SenderEntity)this.get(senderId, false);
        if (senderEntity == null) {
            return;
        }
        senderEntity.sender = sender;
        senderEntity.senderInitiated = true;
    }

    public static void setSenderReferences(String senderId, CommandSender sender) {
        for (Coll<?> coll : Coll.getInstances()) {
            if (!(coll instanceof SenderColl)) continue;
            SenderColl senderColl = (SenderColl)coll;
            senderColl.setSenderReference(senderId, sender);
        }
    }
}

