/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.store;

import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.store.Entity;
import com.massivecraft.massivecore.store.SenderColl;
import com.massivecraft.massivecore.util.IdUtil;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public abstract class SenderEntity<E extends SenderEntity<E>>
extends Entity<E> {
    protected transient CommandSender sender = null;
    protected transient boolean senderInitiated = false;

    public CommandSender getSender() {
        if (!this.senderInitiated) {
            this.initiateSender();
        }
        return this.sender;
    }

    public void initiateSender() {
        String id = this.getId();
        if (id == null) {
            return;
        }
        this.sender = IdUtil.getSender(id);
        this.senderInitiated = true;
    }

    public String getName() {
        return IdUtil.getName(this.getId());
    }

    public UUID getUuid() {
        return IdUtil.getUuid(this.getId());
    }

    @Override
    public SenderColl<E> getColl() {
        return (SenderColl)super.getColl();
    }

    public boolean isPlayer() {
        return IdUtil.isPlayerId(this.getId());
    }

    public boolean isConsole() {
        return IdUtil.isConsoleId(this.getId());
    }

    public Player getPlayer() {
        return IdUtil.getAsPlayer(this.getSender());
    }

    public ConsoleCommandSender getConsole() {
        return IdUtil.getAsConsole(this.getSender());
    }

    public boolean isOnline() {
        return Mixin.isOnline(this.getId());
    }

    public boolean isOffline() {
        return Mixin.isOffline(this.getId());
    }

    public Long getLastPlayed() {
        return Mixin.getLastPlayed(this.getId());
    }

    public Long getFirstPlayed() {
        return Mixin.getFirstPlayed(this.getId());
    }

    public boolean hasPlayedBefore() {
        return Mixin.hasPlayedBefore(this.getId());
    }

    @Deprecated
    public String getDisplayName() {
        return Mixin.getDisplayName(this.getId());
    }

    public String getDisplayName(Object watcherObject) {
        return Mixin.getDisplayName(this.getId(), watcherObject);
    }

    public boolean sendMessage(String message) {
        return Mixin.messageOne((Object)this.getId(), message);
    }

    public boolean sendMessage(String ... messages) {
        return Mixin.messageOne((Object)this.getId(), messages);
    }

    public boolean sendMessage(Collection<String> messages) {
        return Mixin.messageOne((Object)this.getId(), messages);
    }

    public boolean msg(String msg) {
        return Mixin.msgOne((Object)this.getId(), msg);
    }

    public boolean msg(String msg, Object ... args) {
        return Mixin.msgOne(this.getId(), msg, args);
    }

    public boolean msg(Collection<String> msgs) {
        return Mixin.msgOne((Object)this.getId(), msgs);
    }

    public GameMode getGameMode(GameMode def) {
        return IdUtil.getGameMode(this.getId(), def);
    }

    public boolean isGameMode(GameMode gm, boolean def) {
        return IdUtil.isGameMode(this.getId(), gm, def);
    }
}

