/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.store.accessor;

import com.massivecraft.massivecore.store.accessor.FieldAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Accessor {
    private final Class<?> clazz;
    private Map<String, FieldAccessor> fieldToAccessor = new LinkedHashMap<String, FieldAccessor>();
    private static Map<Class<?>, Accessor> classToAccessor = new HashMap();

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Map<String, FieldAccessor> getFieldToAccessor() {
        return this.fieldToAccessor;
    }

    public FieldAccessor getFieldAccessor(String fieldName) {
        FieldAccessor ret = this.fieldToAccessor.get(fieldName);
        if (ret == null) {
            throw new IllegalArgumentException("The field \"" + fieldName + "\" is not supported.");
        }
        return ret;
    }

    public void setFieldAccessor(String fieldName, FieldAccessor fieldAccessor) {
        this.fieldToAccessor.put(fieldName, fieldAccessor);
    }

    public Collection<String> getFieldNames() {
        return this.fieldToAccessor.keySet();
    }

    public static Accessor get(Class<?> clazz) {
        Accessor ret = classToAccessor.get(clazz);
        if (ret != null) {
            return ret;
        }
        return new Accessor(clazz);
    }

    private Accessor(Class<?> clazz) {
        this.clazz = clazz;
        this.populate();
        classToAccessor.put(clazz, this);
    }

    public void populate() {
        Map<String, Field> map = Accessor.getFieldMap(this.clazz);
        for (Map.Entry<String, Field> entry : map.entrySet()) {
            String fieldName = entry.getKey();
            Field field = entry.getValue();
            FieldAccessor fieldAccessor = new FieldAccessor(field);
            this.setFieldAccessor(fieldName, fieldAccessor);
        }
    }

    public Object get(Object object, String fieldName) {
        FieldAccessor fieldAccessor = this.getFieldAccessor(fieldName);
        return fieldAccessor.get(object);
    }

    public void set(Object object, String fieldName, Object val) {
        FieldAccessor fieldAccessor = this.getFieldAccessor(fieldName);
        fieldAccessor.set(object, val);
    }

    public void copy(Object from, Object to, String fieldName) {
        FieldAccessor fieldAccessor = this.getFieldAccessor(fieldName);
        Object val = fieldAccessor.get(from);
        fieldAccessor.set(to, val);
    }

    public void copy(Object from, Object to, Collection<String> fieldNames) {
        for (String fieldName : fieldNames) {
            this.copy(from, to, fieldName);
        }
    }

    public void copy(Object from, Object to) {
        for (FieldAccessor fieldAccessor : this.getFieldToAccessor().values()) {
            Object val = fieldAccessor.get(from);
            fieldAccessor.set(to, val);
        }
    }

    public static List<Field> getFieldList(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        LinkedHashMap<String, Field> ret = new LinkedHashMap<String, Field>();
        for (Field field : Accessor.getFieldList(clazz)) {
            String fieldName;
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || ret.containsKey(fieldName = field.getName())) continue;
            field.setAccessible(true);
            ret.put(fieldName, field);
        }
        return ret;
    }
}

