/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.teleport;

import com.massivecraft.massivecore.EngineAbstract;
import com.massivecraft.massivecore.MassiveCore;
import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.teleport.ScheduledTeleport;
import com.massivecraft.massivecore.util.IdUtil;
import com.massivecraft.massivecore.util.MUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class EngineScheduledTeleport
extends EngineAbstract {
    private static EngineScheduledTeleport i = new EngineScheduledTeleport();
    protected Map<String, ScheduledTeleport> teleporteeIdToScheduledTeleport = new ConcurrentHashMap<String, ScheduledTeleport>();

    public static EngineScheduledTeleport get() {
        return i;
    }

    public boolean isScheduled(ScheduledTeleport st) {
        return this.teleporteeIdToScheduledTeleport.containsValue(st);
    }

    public ScheduledTeleport schedule(ScheduledTeleport st) {
        ScheduledTeleport old = this.teleporteeIdToScheduledTeleport.get(st.getTeleporteeId());
        if (old != null) {
            old.unschedule();
        }
        this.teleporteeIdToScheduledTeleport.put(st.getTeleporteeId(), st);
        st.setDueMillis(System.currentTimeMillis() + (long)(st.getDelaySeconds() * 1000));
        return old;
    }

    public boolean unschedule(ScheduledTeleport st) {
        ScheduledTeleport old = this.teleporteeIdToScheduledTeleport.get(st.getTeleporteeId());
        if (old == null) {
            return false;
        }
        if (old != st) {
            return false;
        }
        return this.teleporteeIdToScheduledTeleport.remove(st.getTeleporteeId()) != null;
    }

    @Override
    public Plugin getPlugin() {
        return MassiveCore.get();
    }

    @Override
    public Long getPeriod() {
        return 1L;
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        for (ScheduledTeleport st : this.teleporteeIdToScheduledTeleport.values()) {
            if (!st.isDue(now)) continue;
            st.run();
        }
    }

    public void cancelTeleport(Player player) {
        ScheduledTeleport scheduledTeleport = this.teleporteeIdToScheduledTeleport.get(IdUtil.getId(player));
        if (scheduledTeleport == null) {
            return;
        }
        scheduledTeleport.unschedule();
        Mixin.msgOne((Object)scheduledTeleport.getTeleporteeId(), "<rose>Cancelled <i>teleport to <h>" + scheduledTeleport.getDestinationDesc() + "<i>.");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void cancelTeleport(PlayerMoveEvent event) {
        if (MUtil.isSameBlock(event.getFrom(), event.getTo())) {
            return;
        }
        this.cancelTeleport(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void cancelTeleport(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.cancelTeleport(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void cancelTeleport(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.cancelTeleport(player);
    }
}

