/*
 * Decompiled with CFR 0.152.
 */
package com.massivecraft.massivecore.teleport;

import com.massivecraft.massivecore.mixin.Mixin;
import com.massivecraft.massivecore.mixin.TeleporterException;
import com.massivecraft.massivecore.teleport.EngineScheduledTeleport;
import com.massivecraft.massivecore.teleport.PSGetter;

public class ScheduledTeleport
implements Runnable {
    private final String teleporteeId;
    private final PSGetter destinationGetter;
    private final String destinationDesc;
    private final int delaySeconds;
    private long dueMillis;

    public String getTeleporteeId() {
        return this.teleporteeId;
    }

    public PSGetter getDestinationGetter() {
        return this.destinationGetter;
    }

    public String getDestinationDesc() {
        return this.destinationDesc;
    }

    public int getDelaySeconds() {
        return this.delaySeconds;
    }

    public long getDueMillis() {
        return this.dueMillis;
    }

    public void setDueMillis(long dueMillis) {
        this.dueMillis = dueMillis;
    }

    public boolean isDue(long now) {
        return now >= this.dueMillis;
    }

    public ScheduledTeleport(String teleporteeId, PSGetter destinationGetter, String destinationDesc, int delaySeconds) {
        this.teleporteeId = teleporteeId;
        this.destinationGetter = destinationGetter;
        this.destinationDesc = destinationDesc;
        this.delaySeconds = delaySeconds;
        this.dueMillis = 0L;
    }

    public boolean isScheduled() {
        return EngineScheduledTeleport.get().isScheduled(this);
    }

    public ScheduledTeleport schedule() {
        return EngineScheduledTeleport.get().schedule(this);
    }

    public boolean unschedule() {
        return EngineScheduledTeleport.get().unschedule(this);
    }

    @Override
    public void run() {
        this.unschedule();
        try {
            Mixin.teleport((Object)this.getTeleporteeId(), this.getDestinationGetter(), this.getDestinationDesc());
        }
        catch (TeleporterException e) {
            Mixin.messageOne((Object)this.getTeleporteeId(), e.getMessage());
        }
    }
}

